/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.prestosql.plugin.base.security.AnyCatalogPermissionsRule;
import io.prestosql.plugin.base.security.AnyCatalogSchemaPermissionsRule;
import io.prestosql.plugin.base.security.SchemaAccessControlRule;
import io.prestosql.spi.connector.CatalogSchemaName;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public class CatalogSchemaAccessControlRule {
    public static final CatalogSchemaAccessControlRule ALLOW_ALL = new CatalogSchemaAccessControlRule(SchemaAccessControlRule.ALLOW_ALL, Optional.empty());
    private final SchemaAccessControlRule schemaAccessControlRule;
    private final Optional<Pattern> catalogRegex;

    @JsonCreator
    public CatalogSchemaAccessControlRule(@JsonProperty(value="owner") boolean owner, @JsonProperty(value="user") Optional<Pattern> userRegex, @JsonProperty(value="group") Optional<Pattern> groupRegex, @JsonProperty(value="schema") Optional<Pattern> schemaRegex, @JsonProperty(value="catalog") Optional<Pattern> catalogRegex) {
        this.schemaAccessControlRule = new SchemaAccessControlRule(owner, userRegex, groupRegex, schemaRegex);
        this.catalogRegex = Objects.requireNonNull(catalogRegex, "catalogRegex is null");
    }

    private CatalogSchemaAccessControlRule(SchemaAccessControlRule schemaAccessControlRule, Optional<Pattern> catalogRegex) {
        this.schemaAccessControlRule = schemaAccessControlRule;
        this.catalogRegex = catalogRegex;
    }

    public Optional<Boolean> match(String user, Set<String> groups, CatalogSchemaName schema) {
        if (!this.catalogRegex.map(regex -> regex.matcher(schema.getCatalogName()).matches()).orElse(true).booleanValue()) {
            return Optional.empty();
        }
        return this.schemaAccessControlRule.match(user, groups, schema.getSchemaName());
    }

    Optional<AnyCatalogPermissionsRule> toAnyCatalogPermissionsRule() {
        if (!this.schemaAccessControlRule.isOwner()) {
            return Optional.empty();
        }
        return Optional.of(new AnyCatalogPermissionsRule(this.schemaAccessControlRule.getUserRegex(), this.schemaAccessControlRule.getGroupRegex(), this.catalogRegex));
    }

    Optional<AnyCatalogSchemaPermissionsRule> toAnyCatalogSchemaPermissionsRule() {
        if (!this.schemaAccessControlRule.isOwner()) {
            return Optional.empty();
        }
        return Optional.of(new AnyCatalogSchemaPermissionsRule(this.schemaAccessControlRule.getUserRegex(), this.schemaAccessControlRule.getGroupRegex(), this.catalogRegex, this.schemaAccessControlRule.getSchemaRegex()));
    }
}

