/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.argument;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.argument.BoxedArgumentFactory;
import org.jdbi.v3.core.argument.DirectArgumentFactory;
import org.jdbi.v3.core.argument.EnumArgumentFactory;
import org.jdbi.v3.core.argument.EssentialsArgumentFactory;
import org.jdbi.v3.core.argument.InternetArgumentFactory;
import org.jdbi.v3.core.argument.JavaTimeArgumentFactory;
import org.jdbi.v3.core.argument.JavaTimeZoneIdArgumentFactory;
import org.jdbi.v3.core.argument.NVarcharArgumentFactory;
import org.jdbi.v3.core.argument.NullArgument;
import org.jdbi.v3.core.argument.OptionalArgumentFactory;
import org.jdbi.v3.core.argument.PrimitivesArgumentFactory;
import org.jdbi.v3.core.argument.QualifiedArgumentFactory;
import org.jdbi.v3.core.argument.SqlArgumentFactory;
import org.jdbi.v3.core.argument.SqlTimeArgumentFactory;
import org.jdbi.v3.core.argument.UntypedNullArgumentFactory;
import org.jdbi.v3.core.array.SqlArrayArgumentFactory;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.meta.Beta;

public class Arguments
implements JdbiConfig<Arguments> {
    private final List<QualifiedArgumentFactory> factories = new CopyOnWriteArrayList<QualifiedArgumentFactory>();
    private final Map<QualifiedType<?>, Function<Object, Argument>> preparedFactories = new ConcurrentHashMap();
    private final Set<QualifiedType<?>> didPrepare = ConcurrentHashMap.newKeySet();
    private ConfigRegistry registry;
    private Argument untypedNullArgument = new NullArgument(1111);
    private boolean bindingNullToPrimitivesPermitted = true;

    public Arguments(ConfigRegistry registry) {
        this.registry = registry;
        this.register(new UntypedNullArgumentFactory());
        this.register(new PrimitivesArgumentFactory());
        this.register(new BoxedArgumentFactory());
        this.register(new SqlArgumentFactory());
        this.register(new InternetArgumentFactory());
        this.register(new SqlTimeArgumentFactory());
        this.register(new JavaTimeArgumentFactory());
        this.register(new SqlArrayArgumentFactory());
        this.register(new EssentialsArgumentFactory());
        this.register(new JavaTimeZoneIdArgumentFactory());
        this.register(new NVarcharArgumentFactory());
        this.register(new EnumArgumentFactory());
        this.register(new OptionalArgumentFactory());
        this.register(new DirectArgumentFactory());
    }

    @Override
    public void setRegistry(ConfigRegistry registry) {
        this.registry = registry;
    }

    private Arguments(Arguments that) {
        this.factories.addAll(that.factories);
        this.untypedNullArgument = that.untypedNullArgument;
        this.bindingNullToPrimitivesPermitted = that.bindingNullToPrimitivesPermitted;
    }

    public Arguments register(ArgumentFactory factory) {
        return this.register(QualifiedArgumentFactory.adapt(this.registry, factory));
    }

    @Beta
    public Arguments register(QualifiedArgumentFactory factory) {
        this.factories.add(0, factory);
        return this;
    }

    public Optional<Argument> findFor(Type type, Object value) {
        return this.findFor(QualifiedType.of(type), value);
    }

    @Beta
    public Optional<Argument> findFor(QualifiedType<?> type, Object value) {
        Function<Object, Argument> prepared = this.preparedFactories.get(type);
        if (prepared != null) {
            return Optional.of(prepared.apply(value));
        }
        for (QualifiedArgumentFactory factory : this.factories) {
            Optional<Argument> maybeBuilt = factory.build(type, value, this.registry);
            if (!maybeBuilt.isPresent()) continue;
            if (factory instanceof QualifiedArgumentFactory.Preparable && this.didPrepare.add(type)) {
                ((QualifiedArgumentFactory.Preparable)factory).prepare(type, this.registry).ifPresent(argumentFactory -> this.preparedFactories.putIfAbsent(type, (Function<Object, Argument>)argumentFactory));
            }
            return maybeBuilt;
        }
        return Optional.empty();
    }

    public Optional<Function<Object, Argument>> prepareFor(Type type) {
        return this.prepareFor(QualifiedType.of(type));
    }

    @Beta
    public Optional<Function<Object, Argument>> prepareFor(QualifiedType<?> type) {
        Function<Object, Argument> prepared = this.preparedFactories.get(type);
        if (prepared != null) {
            return Optional.of(prepared);
        }
        for (QualifiedArgumentFactory factory : this.factories) {
            Optional<Function<Object, Argument>> argumentFactory;
            if (!(factory instanceof QualifiedArgumentFactory.Preparable) || !(argumentFactory = ((QualifiedArgumentFactory.Preparable)factory).prepare(type, this.registry)).isPresent()) continue;
            this.preparedFactories.putIfAbsent(type, argumentFactory.get());
            return argumentFactory;
        }
        return Optional.empty();
    }

    @Beta
    public List<QualifiedArgumentFactory> getFactories() {
        return Collections.unmodifiableList(this.factories);
    }

    public void setUntypedNullArgument(Argument untypedNullArgument) {
        if (untypedNullArgument == null) {
            throw new IllegalArgumentException("the Argument itself may not be null");
        }
        this.untypedNullArgument = untypedNullArgument;
    }

    public Argument getUntypedNullArgument() {
        return this.untypedNullArgument;
    }

    public boolean isBindingNullToPrimitivesPermitted() {
        return this.bindingNullToPrimitivesPermitted;
    }

    public void setBindingNullToPrimitivesPermitted(boolean bindingNullToPrimitivesPermitted) {
        this.bindingNullToPrimitivesPermitted = bindingNullToPrimitivesPermitted;
    }

    @Override
    public Arguments createCopy() {
        return new Arguments(this);
    }
}

