/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector.system;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import java.util.Map;
import java.util.Objects;

public class SystemColumnHandle
implements ColumnHandle {
    private final String columnName;

    @JsonCreator
    public SystemColumnHandle(@JsonProperty(value="columnName") String columnName) {
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    public int hashCode() {
        return this.columnName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SystemColumnHandle other = (SystemColumnHandle)obj;
        return this.columnName.equals(other.columnName);
    }

    public String toString() {
        return this.columnName;
    }

    public static Map<String, ColumnHandle> toSystemColumnHandles(ConnectorTableMetadata tableMetadata) {
        return (Map)tableMetadata.getColumns().stream().collect(ImmutableMap.toImmutableMap(ColumnMetadata::getName, column -> new SystemColumnHandle(column.getName())));
    }
}

