/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cost;

import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.execution.scheduler.NodeSchedulerConfig;
import io.prestosql.metadata.InternalNode;
import io.prestosql.metadata.InternalNodeManager;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntSupplier;
import javax.inject.Inject;

public class TaskCountEstimator {
    private final IntSupplier numberOfNodes;

    @Inject
    public TaskCountEstimator(NodeSchedulerConfig nodeSchedulerConfig, InternalNodeManager nodeManager) {
        Objects.requireNonNull(nodeSchedulerConfig, "nodeSchedulerConfig is null");
        Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.numberOfNodes = () -> {
            Set<InternalNode> activeNodes = nodeManager.getAllNodes().getActiveNodes();
            if (nodeSchedulerConfig.isIncludeCoordinator()) {
                return activeNodes.size();
            }
            return Math.toIntExact(activeNodes.stream().filter(node -> !node.isCoordinator()).count());
        };
    }

    public TaskCountEstimator(IntSupplier numberOfNodes) {
        this.numberOfNodes = Objects.requireNonNull(numberOfNodes, "numberOfNodes is null");
    }

    public int estimateSourceDistributedTaskCount(Session session) {
        Integer costEstimationWorkerCount = SystemSessionProperties.getCostEstimationWorkerCount(session);
        if (costEstimationWorkerCount != null) {
            return costEstimationWorkerCount;
        }
        return this.numberOfNodes.getAsInt();
    }

    public int estimateHashedTaskCount(Session session) {
        return Math.min(this.estimateSourceDistributedTaskCount(session), SystemSessionProperties.getHashPartitionCount(session));
    }
}

