/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.PrincipalType;
import io.prestosql.sql.NodeUtils;
import io.prestosql.sql.ParameterUtils;
import io.prestosql.sql.analyzer.SemanticExceptions;
import io.prestosql.sql.tree.CreateSchema;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.PrincipalSpecification;
import io.prestosql.sql.tree.Statement;
import io.prestosql.transaction.TransactionManager;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CreateSchemaTask
implements DataDefinitionTask<CreateSchema> {
    @Override
    public String getName() {
        return "CREATE SCHEMA";
    }

    @Override
    public String explain(CreateSchema statement, List<Expression> parameters) {
        return "CREATE SCHEMA " + statement.getSchemaName();
    }

    @Override
    public ListenableFuture<?> execute(CreateSchema statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        return this.internalExecute(statement, metadata, accessControl, stateMachine.getSession(), parameters);
    }

    @VisibleForTesting
    ListenableFuture<?> internalExecute(CreateSchema statement, Metadata metadata, AccessControl accessControl, Session session, List<Expression> parameters) {
        block4: {
            CatalogSchemaName schema = MetadataUtil.createCatalogSchemaName(session, (Node)statement, Optional.of(statement.getSchemaName()));
            accessControl.checkCanCreateSchema(session.toSecurityContext(), schema);
            if (metadata.schemaExists(session, schema)) {
                if (!statement.isNotExists()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_ALREADY_EXISTS, (Node)statement, "Schema '%s' already exists", schema);
                }
                return Futures.immediateFuture(null);
            }
            CatalogName catalogName = metadata.getCatalogHandle(session, schema.getCatalogName()).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog does not exist: " + schema.getCatalogName()));
            Map<String, Object> properties = metadata.getSchemaPropertyManager().getProperties(catalogName, schema.getCatalogName(), NodeUtils.mapFromProperties(statement.getProperties()), session, metadata, accessControl, ParameterUtils.parameterExtractor((Statement)statement, parameters));
            PrestoPrincipal principal = this.getCreatePrincipal(statement, session, metadata);
            try {
                metadata.createSchema(session, schema, properties, principal);
            }
            catch (PrestoException e) {
                if (e.getErrorCode().equals((Object)StandardErrorCode.ALREADY_EXISTS.toErrorCode()) && statement.isNotExists()) break block4;
                throw e;
            }
        }
        return Futures.immediateFuture(null);
    }

    private PrestoPrincipal getCreatePrincipal(CreateSchema statement, Session session, Metadata metadata) {
        if (statement.getPrincipal().isPresent()) {
            PrestoPrincipal principal = MetadataUtil.createPrincipal((PrincipalSpecification)statement.getPrincipal().get());
            String catalog = MetadataUtil.getSessionCatalog(metadata, session, (Node)statement);
            if (principal.getType() == PrincipalType.ROLE && !metadata.listRoles(session, catalog).contains(principal.getName())) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.ROLE_NOT_FOUND, (Node)statement, "Role '%s' does not exist", principal.getName());
            }
            return principal;
        }
        return new PrestoPrincipal(PrincipalType.USER, session.getUser());
    }
}

