/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import io.prestosql.Session;
import io.prestosql.execution.DynamicFiltersCollector;
import io.prestosql.execution.StateMachine;
import io.prestosql.execution.TaskId;
import io.prestosql.execution.TaskInfo;
import io.prestosql.execution.TaskSource;
import io.prestosql.execution.TaskState;
import io.prestosql.execution.TaskStatus;
import io.prestosql.execution.buffer.BufferResult;
import io.prestosql.execution.buffer.OutputBuffers;
import io.prestosql.memory.MemoryPoolAssignmentsRequest;
import io.prestosql.sql.planner.PlanFragment;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;

public interface TaskManager {
    public List<TaskInfo> getAllTaskInfo();

    public TaskInfo getTaskInfo(TaskId var1);

    public TaskStatus getTaskStatus(TaskId var1);

    public ListenableFuture<TaskInfo> getTaskInfo(TaskId var1, long var2);

    public String getTaskInstanceId(TaskId var1);

    public ListenableFuture<TaskStatus> getTaskStatus(TaskId var1, long var2);

    public DynamicFiltersCollector.VersionedDynamicFilterDomains acknowledgeAndGetNewDynamicFilterDomains(TaskId var1, long var2);

    public void updateMemoryPoolAssignments(MemoryPoolAssignmentsRequest var1);

    public TaskInfo updateTask(Session var1, TaskId var2, Optional<PlanFragment> var3, List<TaskSource> var4, OutputBuffers var5, OptionalInt var6);

    public TaskInfo cancelTask(TaskId var1);

    public TaskInfo abortTask(TaskId var1);

    public ListenableFuture<BufferResult> getTaskResults(TaskId var1, OutputBuffers.OutputBufferId var2, long var3, DataSize var5);

    public void acknowledgeTaskResults(TaskId var1, OutputBuffers.OutputBufferId var2, long var3);

    public TaskInfo abortTaskResults(TaskId var1, OutputBuffers.OutputBufferId var2);

    public void addStateChangeListener(TaskId var1, StateMachine.StateChangeListener<TaskState> var2);
}

