/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution.buffer;

import com.google.common.collect.AbstractIterator;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import io.prestosql.block.BlockSerdeUtil;
import io.prestosql.execution.buffer.PageCodecMarker;
import io.prestosql.execution.buffer.PagesSerde;
import io.prestosql.execution.buffer.SerializedPage;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockEncodingSerde;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public final class PagesSerdeUtil {
    public static final long NO_CHECKSUM = 81985529216486895L;

    private PagesSerdeUtil() {
    }

    static void writeRawPage(Page page, SliceOutput output, BlockEncodingSerde serde) {
        output.writeInt(page.getChannelCount());
        for (int channel = 0; channel < page.getChannelCount(); ++channel) {
            BlockSerdeUtil.writeBlock(serde, output, page.getBlock(channel));
        }
    }

    static Page readRawPage(int positionCount, SliceInput input, BlockEncodingSerde blockEncodingSerde) {
        int numberOfBlocks = input.readInt();
        Block[] blocks = new Block[numberOfBlocks];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = BlockSerdeUtil.readBlock(blockEncodingSerde, input);
        }
        return new Page(positionCount, blocks);
    }

    public static void writeSerializedPage(SliceOutput output, SerializedPage page) {
        output.writeInt(page.getPositionCount());
        output.writeByte((int)page.getPageCodecMarkers());
        output.writeInt(page.getUncompressedSizeInBytes());
        output.writeInt(page.getSizeInBytes());
        output.writeBytes(page.getSlice());
    }

    private static void updateChecksum(XxHash64 hash, SerializedPage page) {
        hash.update(Slices.wrappedIntArray((int[])new int[]{page.getPositionCount(), page.getPageCodecMarkers(), page.getUncompressedSizeInBytes(), page.getSizeInBytes()}));
        hash.update(page.getSlice());
    }

    private static SerializedPage readSerializedPage(SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        PageCodecMarker.MarkerSet markers = PageCodecMarker.MarkerSet.fromByteValue(sliceInput.readByte());
        int uncompressedSizeInBytes = sliceInput.readInt();
        int sizeInBytes = sliceInput.readInt();
        Slice slice = sliceInput.readSlice(sizeInBytes);
        return new SerializedPage(slice, markers, positionCount, uncompressedSizeInBytes);
    }

    public static long writeSerializedPages(SliceOutput sliceOutput, Iterable<SerializedPage> pages) {
        Iterator<SerializedPage> pageIterator = pages.iterator();
        long size = 0L;
        while (pageIterator.hasNext()) {
            SerializedPage page = pageIterator.next();
            PagesSerdeUtil.writeSerializedPage(sliceOutput, page);
            size += (long)page.getSizeInBytes();
        }
        return size;
    }

    public static long calculateChecksum(List<SerializedPage> pages) {
        XxHash64 hash = new XxHash64();
        for (SerializedPage page : pages) {
            PagesSerdeUtil.updateChecksum(hash, page);
        }
        long checksum = hash.hash();
        if (checksum == 81985529216486895L) {
            return checksum + 1L;
        }
        return checksum;
    }

    public static long writePages(PagesSerde serde, SliceOutput sliceOutput, Page ... pages) {
        return PagesSerdeUtil.writePages(serde, sliceOutput, Arrays.asList(pages).iterator());
    }

    public static long writePages(PagesSerde serde, SliceOutput sliceOutput, Iterator<Page> pages) {
        long size = 0L;
        try (PagesSerde.PagesSerdeContext context = serde.newContext();){
            while (pages.hasNext()) {
                Page page = pages.next();
                PagesSerdeUtil.writeSerializedPage(sliceOutput, serde.serialize(context, page));
                size += page.getSizeInBytes();
            }
        }
        return size;
    }

    public static Iterator<Page> readPages(PagesSerde serde, SliceInput sliceInput) {
        return new PageReader(serde, sliceInput);
    }

    public static Iterator<SerializedPage> readSerializedPages(SliceInput sliceInput) {
        return new SerializedPageReader(sliceInput);
    }

    private static class SerializedPageReader
    extends AbstractIterator<SerializedPage> {
        private final SliceInput input;

        SerializedPageReader(SliceInput input) {
            this.input = Objects.requireNonNull(input, "input is null");
        }

        protected SerializedPage computeNext() {
            if (!this.input.isReadable()) {
                return (SerializedPage)this.endOfData();
            }
            return PagesSerdeUtil.readSerializedPage(this.input);
        }
    }

    private static class PageReader
    extends AbstractIterator<Page> {
        private final PagesSerde serde;
        private final PagesSerde.PagesSerdeContext context;
        private final SliceInput input;

        PageReader(PagesSerde serde, SliceInput input) {
            this.serde = Objects.requireNonNull(serde, "serde is null");
            this.input = Objects.requireNonNull(input, "input is null");
            this.context = serde.newContext();
        }

        protected Page computeNext() {
            if (!this.input.isReadable()) {
                this.context.close();
                return (Page)this.endOfData();
            }
            return this.serde.deserialize(this.context, PagesSerdeUtil.readSerializedPage(this.input));
        }
    }
}

