/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.sql.tree.QualifiedName;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class FunctionDependencyDeclaration {
    public static final FunctionDependencyDeclaration NO_DEPENDENCIES = FunctionDependencyDeclaration.builder().build();
    private final Set<TypeSignature> typeDependencies;
    private final Set<FunctionDependency> functionDependencies;
    private final Set<OperatorDependency> operatorDependencies;
    private final Set<CastDependency> castDependencies;

    public static FunctionDependencyDeclarationBuilder builder() {
        return new FunctionDependencyDeclarationBuilder();
    }

    private FunctionDependencyDeclaration(Set<TypeSignature> typeDependencies, Set<FunctionDependency> functionDependencies, Set<OperatorDependency> operatorDependencies, Set<CastDependency> castDependencies) {
        this.typeDependencies = ImmutableSet.copyOf((Collection)Objects.requireNonNull(typeDependencies, "typeDependencies is null"));
        this.functionDependencies = ImmutableSet.copyOf((Collection)Objects.requireNonNull(functionDependencies, "functionDependencies is null"));
        this.operatorDependencies = ImmutableSet.copyOf((Collection)Objects.requireNonNull(operatorDependencies, "operatorDependencies is null"));
        this.castDependencies = ImmutableSet.copyOf((Collection)Objects.requireNonNull(castDependencies, "castDependencies is null"));
    }

    public Set<TypeSignature> getTypeDependencies() {
        return this.typeDependencies;
    }

    public Set<FunctionDependency> getFunctionDependencies() {
        return this.functionDependencies;
    }

    public Set<OperatorDependency> getOperatorDependencies() {
        return this.operatorDependencies;
    }

    public Set<CastDependency> getCastDependencies() {
        return this.castDependencies;
    }

    public static final class CastDependency {
        private final TypeSignature fromType;
        private final TypeSignature toType;
        private final boolean optional;

        private CastDependency(TypeSignature fromType, TypeSignature toType, boolean optional) {
            this.fromType = fromType;
            this.toType = toType;
            this.optional = optional;
        }

        public TypeSignature getFromType() {
            return this.fromType;
        }

        public TypeSignature getToType() {
            return this.toType;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CastDependency that = (CastDependency)o;
            return Objects.equals(this.fromType, that.fromType) && Objects.equals(this.toType, that.toType);
        }

        public int hashCode() {
            return Objects.hash(this.fromType, this.toType);
        }

        public String toString() {
            return String.format("cast(%s, %s)", this.fromType, this.toType);
        }
    }

    public static final class OperatorDependency {
        private final OperatorType operatorType;
        private final List<TypeSignature> argumentTypes;
        private final boolean optional;

        private OperatorDependency(OperatorType operatorType, List<TypeSignature> argumentTypes, boolean optional) {
            this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
            this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
            this.optional = optional;
        }

        public OperatorType getOperatorType() {
            return this.operatorType;
        }

        public List<TypeSignature> getArgumentTypes() {
            return this.argumentTypes;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OperatorDependency that = (OperatorDependency)o;
            return this.operatorType == that.operatorType && Objects.equals(this.argumentTypes, that.argumentTypes);
        }

        public int hashCode() {
            return Objects.hash(this.operatorType, this.argumentTypes);
        }

        public String toString() {
            return this.operatorType + this.argumentTypes.stream().map(TypeSignature::toString).collect(Collectors.joining(", ", "(", ")"));
        }
    }

    public static final class FunctionDependency {
        private final QualifiedName name;
        private final List<TypeSignature> argumentTypes;
        private final boolean optional;

        private FunctionDependency(QualifiedName name, List<TypeSignature> argumentTypes, boolean optional) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
            this.optional = optional;
        }

        public QualifiedName getName() {
            return this.name;
        }

        public List<TypeSignature> getArgumentTypes() {
            return this.argumentTypes;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FunctionDependency that = (FunctionDependency)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.argumentTypes, that.argumentTypes);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.argumentTypes);
        }

        public String toString() {
            return this.name + this.argumentTypes.stream().map(TypeSignature::toString).collect(Collectors.joining(", ", "(", ")"));
        }
    }

    public static final class FunctionDependencyDeclarationBuilder {
        private final Set<TypeSignature> typeDependencies = new LinkedHashSet<TypeSignature>();
        private final Set<FunctionDependency> functionDependencies = new LinkedHashSet<FunctionDependency>();
        private final Set<OperatorDependency> operatorDependencies = new LinkedHashSet<OperatorDependency>();
        private final Set<CastDependency> castDependencies = new LinkedHashSet<CastDependency>();

        private FunctionDependencyDeclarationBuilder() {
        }

        public FunctionDependencyDeclarationBuilder addType(TypeSignature typeSignature) {
            this.typeDependencies.add(typeSignature);
            return this;
        }

        public FunctionDependencyDeclarationBuilder addFunction(QualifiedName name, List<Type> parameterTypes) {
            this.functionDependencies.add(new FunctionDependency(name, (List)parameterTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList()), false));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addFunctionSignature(QualifiedName name, List<TypeSignature> parameterTypes) {
            this.functionDependencies.add(new FunctionDependency(name, parameterTypes, false));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addOptionalFunction(QualifiedName name, List<Type> parameterTypes) {
            this.functionDependencies.add(new FunctionDependency(name, (List)parameterTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList()), true));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addOptionalFunctionSignature(QualifiedName name, List<TypeSignature> parameterTypes) {
            this.functionDependencies.add(new FunctionDependency(name, parameterTypes, true));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addOperator(OperatorType operatorType, List<Type> parameterTypes) {
            this.operatorDependencies.add(new OperatorDependency(operatorType, (List)parameterTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList()), false));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addOperatorSignature(OperatorType operatorType, List<TypeSignature> parameterTypes) {
            this.operatorDependencies.add(new OperatorDependency(operatorType, parameterTypes, false));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addOptionalOperator(OperatorType operatorType, List<Type> parameterTypes) {
            this.operatorDependencies.add(new OperatorDependency(operatorType, (List)parameterTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList()), true));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addOptionalOperatorSignature(OperatorType operatorType, List<TypeSignature> parameterTypes) {
            this.operatorDependencies.add(new OperatorDependency(operatorType, parameterTypes, true));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addCast(Type fromType, Type toType) {
            this.castDependencies.add(new CastDependency(fromType.getTypeSignature(), toType.getTypeSignature(), false));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addCastSignature(TypeSignature fromType, TypeSignature toType) {
            this.castDependencies.add(new CastDependency(fromType, toType, false));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addOptionalCast(Type fromType, Type toType) {
            this.castDependencies.add(new CastDependency(fromType.getTypeSignature(), toType.getTypeSignature(), true));
            return this;
        }

        public FunctionDependencyDeclarationBuilder addOptionalCastSignature(TypeSignature fromType, TypeSignature toType) {
            this.castDependencies.add(new CastDependency(fromType, toType, true));
            return this;
        }

        public FunctionDependencyDeclaration build() {
            return new FunctionDependencyDeclaration(this.typeDependencies, this.functionDependencies, this.operatorDependencies, this.castDependencies);
        }
    }
}

