/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.prestosql.metadata.AggregationFunctionMetadata;
import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.FunctionDependencies;
import io.prestosql.metadata.FunctionDependencyDeclaration;
import io.prestosql.metadata.FunctionId;
import io.prestosql.metadata.FunctionInvoker;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionListBuilder;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.LiteralFunction;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlAggregationFunction;
import io.prestosql.metadata.SqlFunction;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.operator.aggregation.ApproximateCountDistinctAggregation;
import io.prestosql.operator.aggregation.ApproximateDoublePercentileAggregations;
import io.prestosql.operator.aggregation.ApproximateDoublePercentileArrayAggregations;
import io.prestosql.operator.aggregation.ApproximateLongPercentileAggregations;
import io.prestosql.operator.aggregation.ApproximateLongPercentileArrayAggregations;
import io.prestosql.operator.aggregation.ApproximateRealPercentileAggregations;
import io.prestosql.operator.aggregation.ApproximateRealPercentileArrayAggregations;
import io.prestosql.operator.aggregation.ApproximateSetAggregation;
import io.prestosql.operator.aggregation.ArbitraryAggregationFunction;
import io.prestosql.operator.aggregation.AverageAggregations;
import io.prestosql.operator.aggregation.BigintApproximateMostFrequent;
import io.prestosql.operator.aggregation.BitwiseAndAggregation;
import io.prestosql.operator.aggregation.BitwiseOrAggregation;
import io.prestosql.operator.aggregation.BooleanAndAggregation;
import io.prestosql.operator.aggregation.BooleanOrAggregation;
import io.prestosql.operator.aggregation.CentralMomentsAggregation;
import io.prestosql.operator.aggregation.ChecksumAggregationFunction;
import io.prestosql.operator.aggregation.CountAggregation;
import io.prestosql.operator.aggregation.CountColumn;
import io.prestosql.operator.aggregation.CountIfAggregation;
import io.prestosql.operator.aggregation.DecimalAverageAggregation;
import io.prestosql.operator.aggregation.DecimalSumAggregation;
import io.prestosql.operator.aggregation.DefaultApproximateCountDistinctAggregation;
import io.prestosql.operator.aggregation.DoubleCorrelationAggregation;
import io.prestosql.operator.aggregation.DoubleCovarianceAggregation;
import io.prestosql.operator.aggregation.DoubleHistogramAggregation;
import io.prestosql.operator.aggregation.DoubleRegressionAggregation;
import io.prestosql.operator.aggregation.DoubleSumAggregation;
import io.prestosql.operator.aggregation.GeometricMeanAggregations;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.operator.aggregation.IntervalDayToSecondAverageAggregation;
import io.prestosql.operator.aggregation.IntervalDayToSecondSumAggregation;
import io.prestosql.operator.aggregation.IntervalYearToMonthAverageAggregation;
import io.prestosql.operator.aggregation.IntervalYearToMonthSumAggregation;
import io.prestosql.operator.aggregation.LongSumAggregation;
import io.prestosql.operator.aggregation.MapAggregationFunction;
import io.prestosql.operator.aggregation.MapUnionAggregation;
import io.prestosql.operator.aggregation.MaxAggregationFunction;
import io.prestosql.operator.aggregation.MaxDataSizeForStats;
import io.prestosql.operator.aggregation.MaxNAggregationFunction;
import io.prestosql.operator.aggregation.MergeHyperLogLogAggregation;
import io.prestosql.operator.aggregation.MergeQuantileDigestFunction;
import io.prestosql.operator.aggregation.MergeTDigestAggregation;
import io.prestosql.operator.aggregation.MinAggregationFunction;
import io.prestosql.operator.aggregation.MinNAggregationFunction;
import io.prestosql.operator.aggregation.QuantileDigestAggregationFunction;
import io.prestosql.operator.aggregation.RealAverageAggregation;
import io.prestosql.operator.aggregation.RealCorrelationAggregation;
import io.prestosql.operator.aggregation.RealCovarianceAggregation;
import io.prestosql.operator.aggregation.RealGeometricMeanAggregations;
import io.prestosql.operator.aggregation.RealHistogramAggregation;
import io.prestosql.operator.aggregation.RealRegressionAggregation;
import io.prestosql.operator.aggregation.RealSumAggregation;
import io.prestosql.operator.aggregation.ReduceAggregationFunction;
import io.prestosql.operator.aggregation.SumDataSizeForStats;
import io.prestosql.operator.aggregation.TDigestAggregationFunction;
import io.prestosql.operator.aggregation.VarcharApproximateMostFrequent;
import io.prestosql.operator.aggregation.VarianceAggregation;
import io.prestosql.operator.aggregation.arrayagg.ArrayAggregationFunction;
import io.prestosql.operator.aggregation.histogram.Histogram;
import io.prestosql.operator.aggregation.minmaxby.MaxByAggregationFunction;
import io.prestosql.operator.aggregation.minmaxby.MaxByNAggregationFunction;
import io.prestosql.operator.aggregation.minmaxby.MinByAggregationFunction;
import io.prestosql.operator.aggregation.minmaxby.MinByNAggregationFunction;
import io.prestosql.operator.aggregation.multimapagg.MultimapAggregationFunction;
import io.prestosql.operator.scalar.ArrayAllMatchFunction;
import io.prestosql.operator.scalar.ArrayAnyMatchFunction;
import io.prestosql.operator.scalar.ArrayCardinalityFunction;
import io.prestosql.operator.scalar.ArrayCombinationsFunction;
import io.prestosql.operator.scalar.ArrayConcatFunction;
import io.prestosql.operator.scalar.ArrayConstructor;
import io.prestosql.operator.scalar.ArrayContains;
import io.prestosql.operator.scalar.ArrayContainsSequence;
import io.prestosql.operator.scalar.ArrayDistinctFunction;
import io.prestosql.operator.scalar.ArrayElementAtFunction;
import io.prestosql.operator.scalar.ArrayExceptFunction;
import io.prestosql.operator.scalar.ArrayFilterFunction;
import io.prestosql.operator.scalar.ArrayFlattenFunction;
import io.prestosql.operator.scalar.ArrayFunctions;
import io.prestosql.operator.scalar.ArrayIntersectFunction;
import io.prestosql.operator.scalar.ArrayJoin;
import io.prestosql.operator.scalar.ArrayMaxFunction;
import io.prestosql.operator.scalar.ArrayMinFunction;
import io.prestosql.operator.scalar.ArrayNgramsFunction;
import io.prestosql.operator.scalar.ArrayNoneMatchFunction;
import io.prestosql.operator.scalar.ArrayPositionFunction;
import io.prestosql.operator.scalar.ArrayReduceFunction;
import io.prestosql.operator.scalar.ArrayRemoveFunction;
import io.prestosql.operator.scalar.ArrayReverseFunction;
import io.prestosql.operator.scalar.ArrayShuffleFunction;
import io.prestosql.operator.scalar.ArraySliceFunction;
import io.prestosql.operator.scalar.ArraySortComparatorFunction;
import io.prestosql.operator.scalar.ArraySortFunction;
import io.prestosql.operator.scalar.ArraySubscriptOperator;
import io.prestosql.operator.scalar.ArrayToArrayCast;
import io.prestosql.operator.scalar.ArrayToElementConcatFunction;
import io.prestosql.operator.scalar.ArrayToJsonCast;
import io.prestosql.operator.scalar.ArrayTransformFunction;
import io.prestosql.operator.scalar.ArrayUnionFunction;
import io.prestosql.operator.scalar.ArraysOverlapFunction;
import io.prestosql.operator.scalar.BitwiseFunctions;
import io.prestosql.operator.scalar.CastFromUnknownOperator;
import io.prestosql.operator.scalar.CharacterStringCasts;
import io.prestosql.operator.scalar.ColorFunctions;
import io.prestosql.operator.scalar.CombineHashFunction;
import io.prestosql.operator.scalar.ConcatFunction;
import io.prestosql.operator.scalar.ConcatWsFunction;
import io.prestosql.operator.scalar.DataSizeFunctions;
import io.prestosql.operator.scalar.DateTimeFunctions;
import io.prestosql.operator.scalar.ElementToArrayConcatFunction;
import io.prestosql.operator.scalar.EmptyMapConstructor;
import io.prestosql.operator.scalar.FailureFunction;
import io.prestosql.operator.scalar.FormatFunction;
import io.prestosql.operator.scalar.GenericComparisonOperator;
import io.prestosql.operator.scalar.GenericDistinctFromOperator;
import io.prestosql.operator.scalar.GenericEqualOperator;
import io.prestosql.operator.scalar.GenericHashCodeOperator;
import io.prestosql.operator.scalar.GenericIndeterminateOperator;
import io.prestosql.operator.scalar.GenericLessThanOperator;
import io.prestosql.operator.scalar.GenericLessThanOrEqualOperator;
import io.prestosql.operator.scalar.GenericXxHash64Operator;
import io.prestosql.operator.scalar.Greatest;
import io.prestosql.operator.scalar.HmacFunctions;
import io.prestosql.operator.scalar.HyperLogLogFunctions;
import io.prestosql.operator.scalar.IdentityCast;
import io.prestosql.operator.scalar.JoniRegexpCasts;
import io.prestosql.operator.scalar.JoniRegexpFunctions;
import io.prestosql.operator.scalar.JoniRegexpReplaceLambdaFunction;
import io.prestosql.operator.scalar.JsonFunctions;
import io.prestosql.operator.scalar.JsonOperators;
import io.prestosql.operator.scalar.JsonStringToArrayCast;
import io.prestosql.operator.scalar.JsonStringToMapCast;
import io.prestosql.operator.scalar.JsonStringToRowCast;
import io.prestosql.operator.scalar.JsonToArrayCast;
import io.prestosql.operator.scalar.JsonToMapCast;
import io.prestosql.operator.scalar.JsonToRowCast;
import io.prestosql.operator.scalar.Least;
import io.prestosql.operator.scalar.LuhnCheckFunction;
import io.prestosql.operator.scalar.MapCardinalityFunction;
import io.prestosql.operator.scalar.MapConcatFunction;
import io.prestosql.operator.scalar.MapConstructor;
import io.prestosql.operator.scalar.MapElementAtFunction;
import io.prestosql.operator.scalar.MapEntriesFunction;
import io.prestosql.operator.scalar.MapFilterFunction;
import io.prestosql.operator.scalar.MapFromEntriesFunction;
import io.prestosql.operator.scalar.MapKeys;
import io.prestosql.operator.scalar.MapSubscriptOperator;
import io.prestosql.operator.scalar.MapToJsonCast;
import io.prestosql.operator.scalar.MapToMapCast;
import io.prestosql.operator.scalar.MapTransformKeysFunction;
import io.prestosql.operator.scalar.MapTransformValuesFunction;
import io.prestosql.operator.scalar.MapValues;
import io.prestosql.operator.scalar.MapZipWithFunction;
import io.prestosql.operator.scalar.MathFunctions;
import io.prestosql.operator.scalar.MultimapFromEntriesFunction;
import io.prestosql.operator.scalar.QuantileDigestFunctions;
import io.prestosql.operator.scalar.Re2JCastToRegexpFunction;
import io.prestosql.operator.scalar.Re2JRegexpFunctions;
import io.prestosql.operator.scalar.Re2JRegexpReplaceLambdaFunction;
import io.prestosql.operator.scalar.RepeatFunction;
import io.prestosql.operator.scalar.RowToJsonCast;
import io.prestosql.operator.scalar.RowToRowCast;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.operator.scalar.SequenceFunction;
import io.prestosql.operator.scalar.SessionFunctions;
import io.prestosql.operator.scalar.SplitToMapFunction;
import io.prestosql.operator.scalar.SplitToMultimapFunction;
import io.prestosql.operator.scalar.StringFunctions;
import io.prestosql.operator.scalar.TDigestFunctions;
import io.prestosql.operator.scalar.TryCastFunction;
import io.prestosql.operator.scalar.TryFunction;
import io.prestosql.operator.scalar.TypeOfFunction;
import io.prestosql.operator.scalar.UrlFunctions;
import io.prestosql.operator.scalar.VarbinaryFunctions;
import io.prestosql.operator.scalar.WilsonInterval;
import io.prestosql.operator.scalar.WordStemFunction;
import io.prestosql.operator.scalar.ZipFunction;
import io.prestosql.operator.scalar.ZipWithFunction;
import io.prestosql.operator.scalar.time.LocalTimeFunction;
import io.prestosql.operator.scalar.time.TimeFunctions;
import io.prestosql.operator.scalar.time.TimeOperators;
import io.prestosql.operator.scalar.time.TimeToTimeWithTimeZoneCast;
import io.prestosql.operator.scalar.time.TimeToTimestampCast;
import io.prestosql.operator.scalar.time.TimeToTimestampWithTimeZoneCast;
import io.prestosql.operator.scalar.timestamp.DateAdd;
import io.prestosql.operator.scalar.timestamp.DateFormat;
import io.prestosql.operator.scalar.timestamp.DateToTimestampCast;
import io.prestosql.operator.scalar.timestamp.ExtractHour;
import io.prestosql.operator.scalar.timestamp.ExtractMonth;
import io.prestosql.operator.scalar.timestamp.ExtractQuarter;
import io.prestosql.operator.scalar.timestamp.ExtractYearOfWeek;
import io.prestosql.operator.scalar.timestamp.HumanReadableSeconds;
import io.prestosql.operator.scalar.timestamp.LastDayOfMonth;
import io.prestosql.operator.scalar.timestamp.LocalTimestamp;
import io.prestosql.operator.scalar.timestamp.SequenceIntervalDayToSecond;
import io.prestosql.operator.scalar.timestamp.SequenceIntervalYearToMonth;
import io.prestosql.operator.scalar.timestamp.TimeWithTimeZoneToTimestampCast;
import io.prestosql.operator.scalar.timestamp.TimestampOperators;
import io.prestosql.operator.scalar.timestamp.TimestampToDateCast;
import io.prestosql.operator.scalar.timestamp.TimestampToJsonCast;
import io.prestosql.operator.scalar.timestamp.TimestampToTimeCast;
import io.prestosql.operator.scalar.timestamp.TimestampToTimeWithTimeZoneCast;
import io.prestosql.operator.scalar.timestamp.TimestampToTimestampCast;
import io.prestosql.operator.scalar.timestamp.TimestampToTimestampWithTimeZoneCast;
import io.prestosql.operator.scalar.timestamp.TimestampToVarcharCast;
import io.prestosql.operator.scalar.timestamp.ToUnixTime;
import io.prestosql.operator.scalar.timestamp.VarcharToTimestampCast;
import io.prestosql.operator.scalar.timestamp.WithTimeZone;
import io.prestosql.operator.scalar.timestamptz.AtTimeZoneWithOffset;
import io.prestosql.operator.scalar.timestamptz.CurrentTimestamp;
import io.prestosql.operator.scalar.timestamptz.DateDiff;
import io.prestosql.operator.scalar.timestamptz.DateToTimestampWithTimeZoneCast;
import io.prestosql.operator.scalar.timestamptz.ExtractDay;
import io.prestosql.operator.scalar.timestamptz.ExtractDayOfWeek;
import io.prestosql.operator.scalar.timestamptz.ExtractDayOfYear;
import io.prestosql.operator.scalar.timestamptz.ExtractMillisecond;
import io.prestosql.operator.scalar.timestamptz.ExtractMinute;
import io.prestosql.operator.scalar.timestamptz.ExtractSecond;
import io.prestosql.operator.scalar.timestamptz.ExtractWeekOfYear;
import io.prestosql.operator.scalar.timestamptz.ExtractYear;
import io.prestosql.operator.scalar.timestamptz.FormatDateTime;
import io.prestosql.operator.scalar.timestamptz.TimeZoneHour;
import io.prestosql.operator.scalar.timestamptz.TimeZoneMinute;
import io.prestosql.operator.scalar.timestamptz.TimestampWithTimeZoneOperators;
import io.prestosql.operator.scalar.timestamptz.TimestampWithTimeZoneToDateCast;
import io.prestosql.operator.scalar.timestamptz.TimestampWithTimeZoneToTimeCast;
import io.prestosql.operator.scalar.timestamptz.TimestampWithTimeZoneToTimeWithTimeZoneCast;
import io.prestosql.operator.scalar.timestamptz.TimestampWithTimeZoneToTimestampCast;
import io.prestosql.operator.scalar.timestamptz.TimestampWithTimeZoneToTimestampWithTimeZoneCast;
import io.prestosql.operator.scalar.timestamptz.TimestampWithTimeZoneToVarcharCast;
import io.prestosql.operator.scalar.timestamptz.ToIso8601;
import io.prestosql.operator.scalar.timestamptz.VarcharToTimestampWithTimeZoneCast;
import io.prestosql.operator.scalar.timetz.AtTimeZone;
import io.prestosql.operator.scalar.timetz.CurrentTime;
import io.prestosql.operator.scalar.timetz.DateTrunc;
import io.prestosql.operator.scalar.timetz.TimeWithTimeZoneOperators;
import io.prestosql.operator.scalar.timetz.TimeWithTimeZoneToTimeCast;
import io.prestosql.operator.scalar.timetz.TimeWithTimeZoneToTimeWithTimeZoneCast;
import io.prestosql.operator.scalar.timetz.TimeWithTimeZoneToTimestampWithTimeZoneCast;
import io.prestosql.operator.scalar.timetz.TimeWithTimeZoneToVarcharCast;
import io.prestosql.operator.scalar.timetz.VarcharToTimeWithTimeZoneCast;
import io.prestosql.operator.window.AggregateWindowFunction;
import io.prestosql.operator.window.CumulativeDistributionFunction;
import io.prestosql.operator.window.DenseRankFunction;
import io.prestosql.operator.window.FirstValueFunction;
import io.prestosql.operator.window.LagFunction;
import io.prestosql.operator.window.LastValueFunction;
import io.prestosql.operator.window.LeadFunction;
import io.prestosql.operator.window.NTileFunction;
import io.prestosql.operator.window.NthValueFunction;
import io.prestosql.operator.window.PercentRankFunction;
import io.prestosql.operator.window.RankFunction;
import io.prestosql.operator.window.RowNumberFunction;
import io.prestosql.operator.window.SqlWindowFunction;
import io.prestosql.operator.window.WindowFunctionSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.TypeOperators;
import io.prestosql.sql.DynamicFilters;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.type.BigintOperators;
import io.prestosql.type.BlockTypeOperators;
import io.prestosql.type.BooleanOperators;
import io.prestosql.type.DateOperators;
import io.prestosql.type.DateTimeOperators;
import io.prestosql.type.DecimalCasts;
import io.prestosql.type.DecimalOperators;
import io.prestosql.type.DecimalSaturatedFloorCasts;
import io.prestosql.type.DecimalToDecimalCasts;
import io.prestosql.type.DoubleOperators;
import io.prestosql.type.HyperLogLogOperators;
import io.prestosql.type.IntegerOperators;
import io.prestosql.type.IntervalDayTimeOperators;
import io.prestosql.type.IntervalYearMonthOperators;
import io.prestosql.type.IpAddressOperators;
import io.prestosql.type.LikeFunctions;
import io.prestosql.type.QuantileDigestOperators;
import io.prestosql.type.RealOperators;
import io.prestosql.type.SmallintOperators;
import io.prestosql.type.TDigestOperators;
import io.prestosql.type.TinyintOperators;
import io.prestosql.type.UuidOperators;
import io.prestosql.type.VarcharOperators;
import io.prestosql.type.setdigest.BuildSetDigestAggregation;
import io.prestosql.type.setdigest.MergeSetDigestAggregation;
import io.prestosql.type.setdigest.SetDigestFunctions;
import io.prestosql.type.setdigest.SetDigestOperators;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class FunctionRegistry {
    private final Cache<FunctionBinding, ScalarFunctionImplementation> specializedScalarCache;
    private final Cache<FunctionBinding, InternalAggregationFunction> specializedAggregationCache;
    private final Cache<FunctionBinding, WindowFunctionSupplier> specializedWindowCache;
    private volatile FunctionMap functions = new FunctionMap();

    public FunctionRegistry(Supplier<BlockEncodingSerde> blockEncodingSerdeSupplier, FeaturesConfig featuresConfig, TypeOperators typeOperators, BlockTypeOperators blockTypeOperators) {
        this.specializedScalarCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).build();
        this.specializedAggregationCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).build();
        this.specializedWindowCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).build();
        FunctionListBuilder builder = new FunctionListBuilder().window(RowNumberFunction.class).window(RankFunction.class).window(DenseRankFunction.class).window(PercentRankFunction.class).window(CumulativeDistributionFunction.class).window(NTileFunction.class).window(FirstValueFunction.class).window(LastValueFunction.class).window(NthValueFunction.class).window(LagFunction.class).window(LeadFunction.class).aggregate(ApproximateCountDistinctAggregation.class).aggregate(DefaultApproximateCountDistinctAggregation.class).aggregate(SumDataSizeForStats.class).aggregate(MaxDataSizeForStats.class).aggregates(CountAggregation.class).aggregates(VarianceAggregation.class).aggregates(CentralMomentsAggregation.class).aggregates(ApproximateLongPercentileAggregations.class).aggregates(ApproximateLongPercentileArrayAggregations.class).aggregates(ApproximateDoublePercentileAggregations.class).aggregates(ApproximateDoublePercentileArrayAggregations.class).aggregates(ApproximateRealPercentileAggregations.class).aggregates(ApproximateRealPercentileArrayAggregations.class).aggregates(CountIfAggregation.class).aggregates(BooleanAndAggregation.class).aggregates(BooleanOrAggregation.class).aggregates(DoubleSumAggregation.class).aggregates(RealSumAggregation.class).aggregates(LongSumAggregation.class).aggregates(IntervalDayToSecondSumAggregation.class).aggregates(IntervalYearToMonthSumAggregation.class).aggregates(AverageAggregations.class).function(RealAverageAggregation.REAL_AVERAGE_AGGREGATION).aggregates(IntervalDayToSecondAverageAggregation.class).aggregates(IntervalYearToMonthAverageAggregation.class).aggregates(GeometricMeanAggregations.class).aggregates(RealGeometricMeanAggregations.class).aggregates(MergeHyperLogLogAggregation.class).aggregates(ApproximateSetAggregation.class).aggregates(TDigestAggregationFunction.class).functions(QuantileDigestAggregationFunction.QDIGEST_AGG, QuantileDigestAggregationFunction.QDIGEST_AGG_WITH_WEIGHT, QuantileDigestAggregationFunction.QDIGEST_AGG_WITH_WEIGHT_AND_ERROR).function(MergeQuantileDigestFunction.MERGE).aggregates(MergeTDigestAggregation.class).aggregates(DoubleHistogramAggregation.class).aggregates(RealHistogramAggregation.class).aggregates(DoubleCovarianceAggregation.class).aggregates(RealCovarianceAggregation.class).aggregates(DoubleRegressionAggregation.class).aggregates(RealRegressionAggregation.class).aggregates(DoubleCorrelationAggregation.class).aggregates(RealCorrelationAggregation.class).aggregates(BitwiseOrAggregation.class).aggregates(BitwiseAndAggregation.class).scalar(RepeatFunction.class).scalars(SequenceFunction.class).scalars(SessionFunctions.class).scalars(StringFunctions.class).scalars(WordStemFunction.class).scalar(SplitToMapFunction.class).scalar(SplitToMultimapFunction.class).scalars(VarbinaryFunctions.class).scalars(UrlFunctions.class).scalars(MathFunctions.class).scalar(MathFunctions.Abs.class).scalar(MathFunctions.Sign.class).scalar(MathFunctions.Round.class).scalar(MathFunctions.RoundN.class).scalar(MathFunctions.Truncate.class).scalar(MathFunctions.TruncateN.class).scalar(MathFunctions.Ceiling.class).scalar(MathFunctions.Floor.class).scalars(BitwiseFunctions.class).scalars(DateTimeFunctions.class).scalar(DateTimeFunctions.FromUnixtimeNanosDecimal.class).scalars(JsonFunctions.class).scalars(ColorFunctions.class).scalars(HyperLogLogFunctions.class).scalars(QuantileDigestFunctions.class).scalars(TDigestFunctions.class).scalars(BooleanOperators.class).scalars(BigintOperators.class).scalars(IntegerOperators.class).scalars(SmallintOperators.class).scalars(TinyintOperators.class).scalars(DoubleOperators.class).scalars(RealOperators.class).scalars(VarcharOperators.class).scalars(DateOperators.class).scalars(IntervalDayTimeOperators.class).scalars(IntervalYearMonthOperators.class).scalars(DateTimeOperators.class).scalars(HyperLogLogOperators.class).scalars(QuantileDigestOperators.class).scalars(TDigestOperators.class).scalars(IpAddressOperators.class).scalars(UuidOperators.class).scalars(LikeFunctions.class).scalars(ArrayFunctions.class).scalars(HmacFunctions.class).scalars(DataSizeFunctions.class).scalar(ArrayCardinalityFunction.class).scalar(ArrayContains.class).scalar(ArrayContainsSequence.class).scalar(ArrayFilterFunction.class).scalar(ArrayPositionFunction.class).scalars(CombineHashFunction.class).scalars(JsonOperators.class).scalars(FailureFunction.class).scalars(JoniRegexpCasts.class).scalars(CharacterStringCasts.class).scalars(LuhnCheckFunction.class).scalar(DecimalOperators.Negation.class).functions(IdentityCast.IDENTITY_CAST, CastFromUnknownOperator.CAST_FROM_UNKNOWN).scalar(ArrayRemoveFunction.class).scalar(ArrayElementAtFunction.class).scalar(ArraySortFunction.class).scalar(ArraySortComparatorFunction.class).scalar(ArrayShuffleFunction.class).scalar(ArrayReverseFunction.class).scalar(ArrayMinFunction.class).scalar(ArrayMaxFunction.class).scalar(ArrayDistinctFunction.class).scalar(ArrayIntersectFunction.class).scalar(ArraysOverlapFunction.class).scalar(ArrayUnionFunction.class).scalar(ArrayExceptFunction.class).scalar(ArraySliceFunction.class).scalar(ArrayCombinationsFunction.class).scalar(ArrayNgramsFunction.class).scalar(ArrayAllMatchFunction.class).scalar(ArrayAnyMatchFunction.class).scalar(ArrayNoneMatchFunction.class).scalar(MapEntriesFunction.class).scalar(MapFromEntriesFunction.class).scalar(MultimapFromEntriesFunction.class).scalar(MapKeys.class).scalar(MapValues.class).scalar(MapCardinalityFunction.class).scalar(EmptyMapConstructor.class).scalar(TypeOfFunction.class).scalar(TryFunction.class).scalar(ConcatWsFunction.ConcatArrayWs.class).scalar(DynamicFilters.Function.class).functions(ZipWithFunction.ZIP_WITH_FUNCTION, MapZipWithFunction.MAP_ZIP_WITH_FUNCTION).functions(ZipFunction.ZIP_FUNCTIONS).functions(ArrayJoin.ARRAY_JOIN, ArrayJoin.ARRAY_JOIN_WITH_NULL_REPLACEMENT).functions(ArrayToArrayCast.ARRAY_TO_ARRAY_CAST).functions(ArrayToElementConcatFunction.ARRAY_TO_ELEMENT_CONCAT_FUNCTION, ElementToArrayConcatFunction.ELEMENT_TO_ARRAY_CONCAT_FUNCTION).function(MapElementAtFunction.MAP_ELEMENT_AT).function(new MapConcatFunction(blockTypeOperators)).function(new MapToMapCast(blockTypeOperators)).function(ArrayFlattenFunction.ARRAY_FLATTEN_FUNCTION).function(ArrayConcatFunction.ARRAY_CONCAT_FUNCTION).functions(ArrayConstructor.ARRAY_CONSTRUCTOR, ArraySubscriptOperator.ARRAY_SUBSCRIPT, ArrayToJsonCast.ARRAY_TO_JSON, JsonToArrayCast.JSON_TO_ARRAY, JsonStringToArrayCast.JSON_STRING_TO_ARRAY).function(ArrayAggregationFunction.ARRAY_AGG).functions(new MapSubscriptOperator()).functions(MapConstructor.MAP_CONSTRUCTOR, MapToJsonCast.MAP_TO_JSON, JsonToMapCast.JSON_TO_MAP, JsonStringToMapCast.JSON_STRING_TO_MAP).functions(new MapAggregationFunction(blockTypeOperators), new MapUnionAggregation(blockTypeOperators)).function(ReduceAggregationFunction.REDUCE_AGG).function(new MultimapAggregationFunction(blockTypeOperators)).functions(DecimalCasts.DECIMAL_TO_VARCHAR_CAST, DecimalCasts.DECIMAL_TO_INTEGER_CAST, DecimalCasts.DECIMAL_TO_BIGINT_CAST, DecimalCasts.DECIMAL_TO_DOUBLE_CAST, DecimalCasts.DECIMAL_TO_REAL_CAST, DecimalCasts.DECIMAL_TO_BOOLEAN_CAST, DecimalCasts.DECIMAL_TO_TINYINT_CAST, DecimalCasts.DECIMAL_TO_SMALLINT_CAST).functions(DecimalCasts.VARCHAR_TO_DECIMAL_CAST, DecimalCasts.INTEGER_TO_DECIMAL_CAST, DecimalCasts.BIGINT_TO_DECIMAL_CAST, DecimalCasts.DOUBLE_TO_DECIMAL_CAST, DecimalCasts.REAL_TO_DECIMAL_CAST, DecimalCasts.BOOLEAN_TO_DECIMAL_CAST, DecimalCasts.TINYINT_TO_DECIMAL_CAST, DecimalCasts.SMALLINT_TO_DECIMAL_CAST).functions(DecimalCasts.JSON_TO_DECIMAL_CAST, DecimalCasts.DECIMAL_TO_JSON_CAST).functions(DecimalOperators.DECIMAL_ADD_OPERATOR, DecimalOperators.DECIMAL_SUBTRACT_OPERATOR, DecimalOperators.DECIMAL_MULTIPLY_OPERATOR, DecimalOperators.DECIMAL_DIVIDE_OPERATOR, DecimalOperators.DECIMAL_MODULUS_OPERATOR).function(DecimalSaturatedFloorCasts.DECIMAL_TO_DECIMAL_SATURATED_FLOOR_CAST).functions(DecimalSaturatedFloorCasts.DECIMAL_TO_BIGINT_SATURATED_FLOOR_CAST, DecimalSaturatedFloorCasts.BIGINT_TO_DECIMAL_SATURATED_FLOOR_CAST).functions(DecimalSaturatedFloorCasts.DECIMAL_TO_INTEGER_SATURATED_FLOOR_CAST, DecimalSaturatedFloorCasts.INTEGER_TO_DECIMAL_SATURATED_FLOOR_CAST).functions(DecimalSaturatedFloorCasts.DECIMAL_TO_SMALLINT_SATURATED_FLOOR_CAST, DecimalSaturatedFloorCasts.SMALLINT_TO_DECIMAL_SATURATED_FLOOR_CAST).functions(DecimalSaturatedFloorCasts.DECIMAL_TO_TINYINT_SATURATED_FLOOR_CAST, DecimalSaturatedFloorCasts.TINYINT_TO_DECIMAL_SATURATED_FLOOR_CAST).function(new Histogram(blockTypeOperators)).function(new ChecksumAggregationFunction(blockTypeOperators)).function(ArbitraryAggregationFunction.ARBITRARY_AGGREGATION).functions(Greatest.GREATEST, Least.LEAST).functions(MaxByAggregationFunction.MAX_BY, MinByAggregationFunction.MIN_BY, new MaxByNAggregationFunction(blockTypeOperators), new MinByNAggregationFunction(blockTypeOperators)).functions(MaxAggregationFunction.MAX_AGGREGATION, MinAggregationFunction.MIN_AGGREGATION, new MaxNAggregationFunction(blockTypeOperators), new MinNAggregationFunction(blockTypeOperators)).function(CountColumn.COUNT_COLUMN).functions(RowToJsonCast.ROW_TO_JSON, JsonToRowCast.JSON_TO_ROW, JsonStringToRowCast.JSON_STRING_TO_ROW, RowToRowCast.ROW_TO_ROW_CAST).functions(ConcatFunction.VARCHAR_CONCAT, ConcatFunction.VARBINARY_CONCAT).function(ConcatWsFunction.CONCAT_WS).function(DecimalToDecimalCasts.DECIMAL_TO_DECIMAL_CAST).function(Re2JCastToRegexpFunction.castVarcharToRe2JRegexp(featuresConfig.getRe2JDfaStatesLimit(), featuresConfig.getRe2JDfaRetries())).function(Re2JCastToRegexpFunction.castCharToRe2JRegexp(featuresConfig.getRe2JDfaStatesLimit(), featuresConfig.getRe2JDfaRetries())).function(DecimalAverageAggregation.DECIMAL_AVERAGE_AGGREGATION).function(DecimalSumAggregation.DECIMAL_SUM_AGGREGATION).function(MathFunctions.DECIMAL_MOD_FUNCTION).functions(ArrayTransformFunction.ARRAY_TRANSFORM_FUNCTION, ArrayReduceFunction.ARRAY_REDUCE_FUNCTION).functions(MapFilterFunction.MAP_FILTER_FUNCTION, new MapTransformKeysFunction(blockTypeOperators), MapTransformValuesFunction.MAP_TRANSFORM_VALUES_FUNCTION).function(FormatFunction.FORMAT_FUNCTION).function(TryCastFunction.TRY_CAST).function(new LiteralFunction(blockEncodingSerdeSupplier)).function(new GenericEqualOperator(typeOperators)).function(new GenericHashCodeOperator(typeOperators)).function(new GenericXxHash64Operator(typeOperators)).function(new GenericDistinctFromOperator(typeOperators)).function(new GenericIndeterminateOperator(typeOperators)).function(new GenericComparisonOperator(typeOperators)).function(new GenericLessThanOperator(typeOperators)).function(new GenericLessThanOrEqualOperator(typeOperators)).aggregate(MergeSetDigestAggregation.class).aggregate(BuildSetDigestAggregation.class).scalars(SetDigestFunctions.class).scalars(SetDigestOperators.class).scalars(WilsonInterval.class).aggregate(BigintApproximateMostFrequent.class).aggregate(VarcharApproximateMostFrequent.class);
        builder.scalar(TimestampOperators.TimestampPlusIntervalDayToSecond.class).scalar(TimestampOperators.IntervalDayToSecondPlusTimestamp.class).scalar(TimestampOperators.TimestampPlusIntervalYearToMonth.class).scalar(TimestampOperators.IntervalYearToMonthPlusTimestamp.class).scalar(TimestampOperators.TimestampMinusIntervalDayToSecond.class).scalar(TimestampOperators.TimestampMinusIntervalYearToMonth.class).scalar(TimestampOperators.TimestampMinusTimestamp.class).scalar(TimestampToTimestampCast.class).scalar(TimestampToTimeCast.class).scalar(TimestampToTimeWithTimeZoneCast.class).scalar(TimestampToTimestampWithTimeZoneCast.class).scalar(TimestampToDateCast.class).scalar(TimestampToVarcharCast.class).scalar(TimestampToJsonCast.class).scalar(DateToTimestampCast.class).scalar(TimeToTimestampCast.class).scalar(TimeWithTimeZoneToTimestampCast.class).scalar(TimestampWithTimeZoneToTimestampCast.class).scalar(VarcharToTimestampCast.class).scalar(LocalTimestamp.class).scalar(io.prestosql.operator.scalar.timestamp.DateTrunc.class).scalar(ToUnixTime.class).scalar(HumanReadableSeconds.class).scalar(io.prestosql.operator.scalar.timestamp.ToIso8601.class).scalar(WithTimeZone.class).scalar(io.prestosql.operator.scalar.timestamp.FormatDateTime.class).scalar(DateFormat.class).scalar(SequenceIntervalYearToMonth.class).scalar(SequenceIntervalDayToSecond.class).scalar(DateAdd.class).scalar(io.prestosql.operator.scalar.timestamp.DateDiff.class).scalar(io.prestosql.operator.scalar.timestamp.ExtractYear.class).scalar(ExtractQuarter.class).scalar(ExtractMonth.class).scalar(io.prestosql.operator.scalar.timestamp.ExtractDay.class).scalar(ExtractHour.class).scalar(io.prestosql.operator.scalar.timestamp.ExtractMinute.class).scalar(io.prestosql.operator.scalar.timestamp.ExtractSecond.class).scalar(io.prestosql.operator.scalar.timestamp.ExtractMillisecond.class).scalar(io.prestosql.operator.scalar.timestamp.ExtractDayOfYear.class).scalar(io.prestosql.operator.scalar.timestamp.ExtractDayOfWeek.class).scalar(io.prestosql.operator.scalar.timestamp.ExtractWeekOfYear.class).scalar(ExtractYearOfWeek.class).scalar(LastDayOfMonth.class);
        builder.scalar(TimestampWithTimeZoneOperators.TimestampPlusIntervalDayToSecond.class).scalar(TimestampWithTimeZoneOperators.IntervalDayToSecondPlusTimestamp.class).scalar(TimestampWithTimeZoneOperators.TimestampMinusIntervalDayToSecond.class).scalar(TimestampWithTimeZoneOperators.TimestampPlusIntervalYearToMonth.class).scalar(TimestampWithTimeZoneOperators.IntervalYearToMonthPlusTimestamp.class).scalar(TimestampWithTimeZoneOperators.TimestampMinusIntervalYearToMonth.class).scalar(TimestampWithTimeZoneOperators.TimestampMinusTimestamp.class).scalar(CurrentTimestamp.class).scalar(ExtractYear.class).scalar(io.prestosql.operator.scalar.timestamptz.ExtractQuarter.class).scalar(io.prestosql.operator.scalar.timestamptz.ExtractMonth.class).scalar(ExtractDay.class).scalar(io.prestosql.operator.scalar.timestamptz.ExtractHour.class).scalar(ExtractMinute.class).scalar(ExtractSecond.class).scalar(ExtractMillisecond.class).scalar(ExtractDayOfYear.class).scalar(ExtractDayOfWeek.class).scalar(ExtractWeekOfYear.class).scalar(io.prestosql.operator.scalar.timestamptz.ExtractYearOfWeek.class).scalar(ToIso8601.class).scalar(io.prestosql.operator.scalar.timestamptz.DateAdd.class).scalar(io.prestosql.operator.scalar.timestamptz.DateTrunc.class).scalar(TimeZoneHour.class).scalar(TimeZoneMinute.class).scalar(DateDiff.class).scalar(io.prestosql.operator.scalar.timestamptz.DateFormat.class).scalar(FormatDateTime.class).scalar(io.prestosql.operator.scalar.timestamptz.ToUnixTime.class).scalar(io.prestosql.operator.scalar.timestamptz.LastDayOfMonth.class).scalar(io.prestosql.operator.scalar.timestamptz.AtTimeZone.class).scalar(AtTimeZoneWithOffset.class).scalar(DateToTimestampWithTimeZoneCast.class).scalar(TimestampWithTimeZoneToDateCast.class).scalar(TimestampWithTimeZoneToTimeCast.class).scalar(TimestampWithTimeZoneToTimestampWithTimeZoneCast.class).scalar(TimestampWithTimeZoneToTimeWithTimeZoneCast.class).scalar(TimestampWithTimeZoneToVarcharCast.class).scalar(TimeToTimestampWithTimeZoneCast.class).scalar(TimeWithTimeZoneToTimestampWithTimeZoneCast.class).scalar(VarcharToTimestampWithTimeZoneCast.class);
        builder.scalar(LocalTimeFunction.class).scalars(TimeOperators.class).scalars(TimeFunctions.class).scalar(TimeToTimeWithTimeZoneCast.class);
        builder.scalar(TimeWithTimeZoneOperators.TimePlusIntervalDayToSecond.class).scalar(TimeWithTimeZoneOperators.IntervalDayToSecondPlusTime.class).scalar(TimeWithTimeZoneOperators.TimeMinusIntervalDayToSecond.class).scalar(TimeWithTimeZoneOperators.TimeMinusTime.class).scalar(TimeWithTimeZoneToTimeCast.class).scalar(TimeWithTimeZoneToTimeWithTimeZoneCast.class).scalar(TimeWithTimeZoneToVarcharCast.class).scalar(VarcharToTimeWithTimeZoneCast.class).scalar(io.prestosql.operator.scalar.timetz.DateDiff.class).scalar(io.prestosql.operator.scalar.timetz.DateAdd.class).scalar(io.prestosql.operator.scalar.timetz.ExtractHour.class).scalar(io.prestosql.operator.scalar.timetz.ExtractMinute.class).scalar(io.prestosql.operator.scalar.timetz.ExtractSecond.class).scalar(io.prestosql.operator.scalar.timetz.ExtractMillisecond.class).scalar(io.prestosql.operator.scalar.timetz.TimeZoneHour.class).scalar(io.prestosql.operator.scalar.timetz.TimeZoneMinute.class).scalar(DateTrunc.class).scalar(AtTimeZone.class).scalar(io.prestosql.operator.scalar.timetz.AtTimeZoneWithOffset.class).scalar(CurrentTime.class);
        switch (featuresConfig.getRegexLibrary()) {
            case JONI: {
                builder.scalars(JoniRegexpFunctions.class);
                builder.scalar(JoniRegexpReplaceLambdaFunction.class);
                break;
            }
            case RE2J: {
                builder.scalars(Re2JRegexpFunctions.class);
                builder.scalar(Re2JRegexpReplaceLambdaFunction.class);
            }
        }
        this.addFunctions(builder.getFunctions());
    }

    public final synchronized void addFunctions(List<? extends SqlFunction> functions) {
        for (SqlFunction sqlFunction : functions) {
            FunctionMetadata functionMetadata;
            String name = sqlFunction.getFunctionMetadata().getSignature().getName();
            if (!(!Signature.isOperatorName(name) || sqlFunction instanceof GenericEqualOperator || sqlFunction instanceof GenericHashCodeOperator || sqlFunction instanceof GenericXxHash64Operator || sqlFunction instanceof GenericDistinctFromOperator || sqlFunction instanceof GenericIndeterminateOperator || sqlFunction instanceof GenericComparisonOperator || sqlFunction instanceof GenericLessThanOperator || sqlFunction instanceof GenericLessThanOrEqualOperator)) {
                OperatorType operatorType = Signature.unmangleOperator(name);
                Preconditions.checkArgument((operatorType != OperatorType.EQUAL && operatorType != OperatorType.HASH_CODE && operatorType != OperatorType.XX_HASH_64 && operatorType != OperatorType.IS_DISTINCT_FROM && operatorType != OperatorType.INDETERMINATE && operatorType != OperatorType.COMPARISON && operatorType != OperatorType.LESS_THAN && operatorType != OperatorType.LESS_THAN_OR_EQUAL ? 1 : 0) != 0, (String)"Can not register %s function: %s", (Object)operatorType, (Object)sqlFunction.getFunctionMetadata().getSignature());
            }
            Preconditions.checkArgument((!(functionMetadata = sqlFunction.getFunctionMetadata()).getSignature().getName().contains("|") ? 1 : 0) != 0, (String)"Function name cannot contain '|' character: %s", (Object)functionMetadata.getSignature());
            for (FunctionMetadata existingFunction : this.functions.list()) {
                Preconditions.checkArgument((!functionMetadata.getFunctionId().equals(existingFunction.getFunctionId()) ? 1 : 0) != 0, (String)"Function already registered: %s", (Object)functionMetadata.getFunctionId());
                Preconditions.checkArgument((!functionMetadata.getSignature().equals(existingFunction.getSignature()) ? 1 : 0) != 0, (String)"Function already registered: %s", (Object)functionMetadata.getSignature());
            }
        }
        this.functions = new FunctionMap(this.functions, functions);
    }

    public List<FunctionMetadata> list() {
        return this.functions.list();
    }

    public Collection<FunctionMetadata> get(QualifiedName name) {
        return this.functions.get(name);
    }

    public FunctionMetadata get(FunctionId functionId) {
        return this.functions.get(functionId).getFunctionMetadata();
    }

    public AggregationFunctionMetadata getAggregationFunctionMetadata(FunctionBinding functionBinding) {
        SqlFunction function = this.functions.get(functionBinding.getFunctionId());
        Preconditions.checkArgument((boolean)(function instanceof SqlAggregationFunction), (String)"%s is not an aggregation function", (Object)functionBinding.getBoundSignature());
        SqlAggregationFunction aggregationFunction = (SqlAggregationFunction)function;
        return aggregationFunction.getAggregationMetadata(functionBinding);
    }

    public WindowFunctionSupplier getWindowFunctionImplementation(FunctionBinding functionBinding, FunctionDependencies functionDependencies) {
        SqlFunction function = this.functions.get(functionBinding.getFunctionId());
        try {
            if (function instanceof SqlAggregationFunction) {
                InternalAggregationFunction aggregationFunction = (InternalAggregationFunction)this.specializedAggregationCache.get((Object)functionBinding, () -> this.specializedAggregation(functionBinding, functionDependencies));
                return AggregateWindowFunction.supplier(function.getFunctionMetadata().getSignature(), aggregationFunction);
            }
            return (WindowFunctionSupplier)this.specializedWindowCache.get((Object)functionBinding, () -> this.specializeWindow(functionBinding, functionDependencies));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
            throw new RuntimeException(e.getCause());
        }
    }

    private WindowFunctionSupplier specializeWindow(FunctionBinding functionBinding, FunctionDependencies functionDependencies) {
        SqlWindowFunction function = (SqlWindowFunction)this.functions.get(functionBinding.getFunctionId());
        return function.specialize(functionBinding, functionDependencies);
    }

    public InternalAggregationFunction getAggregateFunctionImplementation(FunctionBinding functionBinding, FunctionDependencies functionDependencies) {
        try {
            return (InternalAggregationFunction)this.specializedAggregationCache.get((Object)functionBinding, () -> this.specializedAggregation(functionBinding, functionDependencies));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
            throw new RuntimeException(e.getCause());
        }
    }

    private InternalAggregationFunction specializedAggregation(FunctionBinding functionBinding, FunctionDependencies functionDependencies) {
        SqlAggregationFunction function = (SqlAggregationFunction)this.functions.get(functionBinding.getFunctionId());
        return function.specialize(functionBinding, functionDependencies);
    }

    public FunctionDependencyDeclaration getFunctionDependencies(FunctionBinding functionBinding) {
        SqlFunction function = this.functions.get(functionBinding.getFunctionId());
        return function.getFunctionDependencies(functionBinding);
    }

    public FunctionInvoker getScalarFunctionInvoker(FunctionBinding functionBinding, FunctionDependencies functionDependencies, InvocationConvention invocationConvention) {
        ScalarFunctionImplementation scalarFunctionImplementation;
        try {
            scalarFunctionImplementation = (ScalarFunctionImplementation)this.specializedScalarCache.get((Object)functionBinding, () -> this.specializeScalarFunction(functionBinding, functionDependencies));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
            throw new RuntimeException(e.getCause());
        }
        return scalarFunctionImplementation.getScalarFunctionInvoker(invocationConvention);
    }

    private ScalarFunctionImplementation specializeScalarFunction(FunctionBinding functionBinding, FunctionDependencies functionDependencies) {
        SqlScalarFunction function = (SqlScalarFunction)this.functions.get(functionBinding.getFunctionId());
        return function.specialize(functionBinding, functionDependencies);
    }

    private static class FunctionMap {
        private final Map<FunctionId, SqlFunction> functions;
        private final Multimap<QualifiedName, FunctionMetadata> functionsByName;

        public FunctionMap() {
            this.functions = ImmutableMap.of();
            this.functionsByName = ImmutableListMultimap.of();
        }

        public FunctionMap(FunctionMap map, Collection<? extends SqlFunction> functions) {
            this.functions = ImmutableMap.builder().putAll(map.functions).putAll((Map)Maps.uniqueIndex(functions, function -> function.getFunctionMetadata().getFunctionId())).build();
            ImmutableListMultimap.Builder functionsByName = ImmutableListMultimap.builder().putAll(map.functionsByName);
            functions.stream().map(SqlFunction::getFunctionMetadata).forEach(functionMetadata -> functionsByName.put((Object)QualifiedName.of((String)functionMetadata.getSignature().getName()), functionMetadata));
            this.functionsByName = functionsByName.build();
            for (Map.Entry entry : this.functionsByName.asMap().entrySet()) {
                Collection values = (Collection)entry.getValue();
                long aggregations = values.stream().map(FunctionMetadata::getKind).filter(kind -> kind == FunctionKind.AGGREGATE).count();
                Preconditions.checkState((aggregations == 0L || aggregations == (long)values.size() ? 1 : 0) != 0, (String)"'%s' is both an aggregation and a scalar function", entry.getKey());
            }
        }

        public List<FunctionMetadata> list() {
            return ImmutableList.copyOf((Collection)this.functionsByName.values());
        }

        public Collection<FunctionMetadata> get(QualifiedName name) {
            return this.functionsByName.get((Object)name);
        }

        public SqlFunction get(FunctionId functionId) {
            SqlFunction sqlFunction = this.functions.get(functionId);
            Preconditions.checkArgument((sqlFunction != null ? 1 : 0) != 0, (String)"Unknown function implementation: %s", (Object)functionId);
            return sqlFunction;
        }
    }
}

