/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.base.Preconditions;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.TypeSignature;
import java.util.Collections;
import java.util.List;

public abstract class SqlOperator
extends SqlScalarFunction {
    protected SqlOperator(OperatorType operatorType, List<TypeVariableConstraint> typeVariableConstraints, List<LongVariableConstraint> longVariableConstraints, TypeSignature returnType, List<TypeSignature> argumentTypes, boolean nullable) {
        super(new FunctionMetadata(new Signature(Signature.mangleOperatorName(operatorType), typeVariableConstraints, longVariableConstraints, returnType, argumentTypes, false), nullable, Collections.nCopies(argumentTypes.size(), new FunctionArgumentDefinition(operatorType == OperatorType.IS_DISTINCT_FROM || operatorType == OperatorType.INDETERMINATE)), true, true, "", FunctionKind.SCALAR));
        if (operatorType == OperatorType.EQUAL || operatorType == OperatorType.SUBSCRIPT) {
            Preconditions.checkArgument((boolean)nullable, (String)"%s operator for %s must be nullable", (Object)operatorType, (Object)argumentTypes.get(0));
        }
    }
}

