/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.Iterators;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.prestosql.memory.context.MemoryTrackingContext;
import io.prestosql.operator.DriverYieldSignal;
import io.prestosql.operator.HashGenerator;
import io.prestosql.operator.JoinProbe;
import io.prestosql.operator.JoinStatisticsCounter;
import io.prestosql.operator.LookupJoinOperators;
import io.prestosql.operator.LookupJoinPageBuilder;
import io.prestosql.operator.LookupSource;
import io.prestosql.operator.LookupSourceFactory;
import io.prestosql.operator.LookupSourceProvider;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorInfo;
import io.prestosql.operator.PageBuffer;
import io.prestosql.operator.PartitionedConsumption;
import io.prestosql.operator.ProcessorContext;
import io.prestosql.operator.SpillContext;
import io.prestosql.operator.StaticLookupSourceProvider;
import io.prestosql.operator.WorkProcessor;
import io.prestosql.operator.WorkProcessorOperatorAdapter;
import io.prestosql.operator.exchange.LocalPartitionGenerator;
import io.prestosql.spi.Page;
import io.prestosql.spi.type.Type;
import io.prestosql.spiller.PartitioningSpiller;
import io.prestosql.spiller.PartitioningSpillerFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Executor;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class LookupJoinOperator
implements WorkProcessorOperatorAdapter.AdapterWorkProcessorOperator {
    private final ListenableFuture<LookupSourceProvider> lookupSourceProviderFuture;
    private final PageBuffer pageBuffer;
    private final WorkProcessor<Page> pages;
    private final SpillingJoinProcessor joinProcessor;
    private final JoinStatisticsCounter statisticsCounter;

    LookupJoinOperator(List<Type> probeTypes, List<Type> buildOutputTypes, LookupJoinOperators.JoinType joinType, LookupSourceFactory lookupSourceFactory, JoinProbe.JoinProbeFactory joinProbeFactory, Runnable afterClose, OptionalInt lookupJoinsCount, HashGenerator hashGenerator, PartitioningSpillerFactory partitioningSpillerFactory, ProcessorContext processorContext, Optional<WorkProcessor<Page>> sourcePages) {
        this.statisticsCounter = new JoinStatisticsCounter(joinType);
        this.lookupSourceProviderFuture = lookupSourceFactory.createLookupSourceProvider();
        this.pageBuffer = new PageBuffer(this.lookupSourceProviderFuture);
        this.joinProcessor = new SpillingJoinProcessor(processorContext, afterClose, lookupJoinsCount, probeTypes, buildOutputTypes, joinType, hashGenerator, joinProbeFactory, lookupSourceFactory, this.lookupSourceProviderFuture, this.statisticsCounter, partitioningSpillerFactory, sourcePages.orElse(this.pageBuffer.pages()));
        this.pages = WorkProcessor.flatten(WorkProcessor.create(this.joinProcessor));
    }

    @Override
    public Optional<OperatorInfo> getOperatorInfo() {
        return Optional.of(this.statisticsCounter.get());
    }

    @Override
    public boolean needsInput() {
        return this.lookupSourceProviderFuture.isDone() && this.pageBuffer.isEmpty() && !this.pageBuffer.isFinished();
    }

    @Override
    public void addInput(Page page) {
        this.pageBuffer.add(page);
    }

    @Override
    public void finish() {
        this.pageBuffer.finish();
    }

    @Override
    public WorkProcessor<Page> getOutputPages() {
        return this.pages;
    }

    @Override
    public void close() {
        this.joinProcessor.close();
    }

    public static class SavedRow {
        public final Page row;
        public final long joinPositionWithinPartition;
        public final boolean currentProbePositionProducedRow;
        public final int joinSourcePositions;

        public SavedRow(Page page, int position, long joinPositionWithinPartition, boolean currentProbePositionProducedRow, int joinSourcePositions) {
            this.row = page.getSingleValuePage(position);
            this.joinPositionWithinPartition = joinPositionWithinPartition;
            this.currentProbePositionProducedRow = currentProbePositionProducedRow;
            this.joinSourcePositions = joinSourcePositions;
        }
    }

    public static class SpillInfoSnapshot {
        private final long spillEpoch;
        private final IntPredicate spillMask;

        public SpillInfoSnapshot(long spillEpoch, IntPredicate spillMask) {
            this.spillEpoch = spillEpoch;
            this.spillMask = Objects.requireNonNull(spillMask, "spillMask is null");
        }

        public static SpillInfoSnapshot from(LookupSourceProvider.LookupSourceLease lookupSourceLease) {
            return new SpillInfoSnapshot(lookupSourceLease.spillEpoch(), lookupSourceLease.getSpillMask());
        }

        public long getSpillEpoch() {
            return this.spillEpoch;
        }

        public IntPredicate getSpillMask() {
            return this.spillMask;
        }
    }

    private static class SpillingJoinProcessor
    implements WorkProcessor.Process<WorkProcessor<Page>> {
        private final ProcessorContext processorContext;
        private final Runnable afterClose;
        private final OptionalInt lookupJoinsCount;
        private final List<Type> probeTypes;
        private final List<Type> buildOutputTypes;
        private final LookupJoinOperators.JoinType joinType;
        private final HashGenerator hashGenerator;
        private final JoinProbe.JoinProbeFactory joinProbeFactory;
        private final LookupSourceFactory lookupSourceFactory;
        private final JoinStatisticsCounter statisticsCounter;
        private final PageJoiner sourcePagesJoiner;
        private final WorkProcessor<Page> joinedSourcePages;
        private boolean closed;
        @Nullable
        private ListenableFuture<PartitionedConsumption<Supplier<LookupSource>>> partitionedConsumption;
        @Nullable
        private Iterator<PartitionedConsumption.Partition<Supplier<LookupSource>>> lookupPartitions;
        @Nullable
        private PartitionedConsumption.Partition<Supplier<LookupSource>> previousPartition;
        @Nullable
        private ListenableFuture<Supplier<LookupSource>> previousPartitionLookupSource;

        private SpillingJoinProcessor(ProcessorContext processorContext, Runnable afterClose, OptionalInt lookupJoinsCount, List<Type> probeTypes, List<Type> buildOutputTypes, LookupJoinOperators.JoinType joinType, HashGenerator hashGenerator, JoinProbe.JoinProbeFactory joinProbeFactory, LookupSourceFactory lookupSourceFactory, ListenableFuture<LookupSourceProvider> lookupSourceProvider, JoinStatisticsCounter statisticsCounter, PartitioningSpillerFactory partitioningSpillerFactory, WorkProcessor<Page> sourcePages) {
            this.processorContext = Objects.requireNonNull(processorContext, "processorContext is null");
            this.afterClose = Objects.requireNonNull(afterClose, "afterClose is null");
            this.lookupJoinsCount = Objects.requireNonNull(lookupJoinsCount, "lookupJoinsCount is null");
            this.probeTypes = Objects.requireNonNull(probeTypes, "probeTypes is null");
            this.buildOutputTypes = Objects.requireNonNull(buildOutputTypes, "buildOutputTypes is null");
            this.joinType = Objects.requireNonNull(joinType, "joinType is null");
            this.hashGenerator = Objects.requireNonNull(hashGenerator, "hashGenerator is null");
            this.joinProbeFactory = Objects.requireNonNull(joinProbeFactory, "joinProbeFactory is null");
            this.lookupSourceFactory = Objects.requireNonNull(lookupSourceFactory, "lookupSourceFactory is null");
            this.statisticsCounter = Objects.requireNonNull(statisticsCounter, "statisticsCounter is null");
            this.sourcePagesJoiner = new PageJoiner(processorContext, probeTypes, buildOutputTypes, joinType, hashGenerator, joinProbeFactory, lookupSourceFactory, lookupSourceProvider, Optional.of(partitioningSpillerFactory), statisticsCounter, Collections.emptyIterator());
            this.joinedSourcePages = sourcePages.transform(this.sourcePagesJoiner);
        }

        @Override
        public WorkProcessor.ProcessState<WorkProcessor<Page>> process() {
            if (!this.joinedSourcePages.isFinished()) {
                return WorkProcessor.ProcessState.ofResult(this.joinedSourcePages);
            }
            if (this.partitionedConsumption == null) {
                this.partitionedConsumption = this.lookupSourceFactory.finishProbeOperator(this.lookupJoinsCount);
                return WorkProcessor.ProcessState.blocked(this.partitionedConsumption);
            }
            if (this.lookupPartitions == null) {
                this.lookupPartitions = ((PartitionedConsumption)MoreFutures.getDone(this.partitionedConsumption)).beginConsumption();
            }
            if (this.previousPartition != null) {
                if (!this.previousPartitionLookupSource.isDone()) {
                    return WorkProcessor.ProcessState.blocked(this.previousPartitionLookupSource);
                }
                this.previousPartition.release();
                this.previousPartition = null;
                this.previousPartitionLookupSource = null;
            }
            if (!this.lookupPartitions.hasNext()) {
                this.close();
                return WorkProcessor.ProcessState.finished();
            }
            PartitionedConsumption.Partition<Supplier<LookupSource>> partition = this.lookupPartitions.next();
            this.previousPartition = partition;
            this.previousPartitionLookupSource = partition.load();
            return WorkProcessor.ProcessState.ofResult(this.joinUnspilledPages(partition));
        }

        private WorkProcessor<Page> joinUnspilledPages(PartitionedConsumption.Partition<Supplier<LookupSource>> partition) {
            int partitionNumber = partition.number();
            WorkProcessor<Page> unspilledInputPages = WorkProcessor.fromIterator(this.sourcePagesJoiner.getSpiller().map(spiller -> spiller.getSpilledPages(partitionNumber)).orElse(Collections.emptyIterator()));
            Iterator<SavedRow> savedRow = Optional.ofNullable(this.sourcePagesJoiner.getSpilledRows().remove(partitionNumber)).map(row -> Iterators.singletonIterator((Object)row)).orElse(Collections.emptyIterator());
            ListenableFuture unspilledLookupSourceProvider = Futures.transform(partition.load(), supplier -> new StaticLookupSourceProvider((LookupSource)supplier.get()), (Executor)MoreExecutors.directExecutor());
            return unspilledInputPages.transform(new PageJoiner(this.processorContext, this.probeTypes, this.buildOutputTypes, this.joinType, this.hashGenerator, this.joinProbeFactory, this.lookupSourceFactory, (ListenableFuture<LookupSourceProvider>)unspilledLookupSourceProvider, Optional.empty(), this.statisticsCounter, savedRow));
        }

        private void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try (Closer closer = Closer.create();){
                closer.register(this.afterClose::run);
                closer.register(() -> this.sourcePagesJoiner.close());
                this.sourcePagesJoiner.getSpiller().ifPresent(arg_0 -> ((Closer)closer).register(arg_0));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class PageJoiner
    implements WorkProcessor.Transformation<Page, Page> {
        private final List<Type> probeTypes;
        private final JoinProbe.JoinProbeFactory joinProbeFactory;
        private final ListenableFuture<LookupSourceProvider> lookupSourceProviderFuture;
        private final Optional<PartitioningSpillerFactory> partitioningSpillerFactory;
        private final SpillContext spillContext;
        private final MemoryTrackingContext memoryTrackingContext;
        private final JoinStatisticsCounter statisticsCounter;
        private final DriverYieldSignal yieldSignal;
        private final Iterator<SavedRow> savedRows;
        private final Supplier<LocalPartitionGenerator> partitionGenerator;
        private final LookupJoinPageBuilder pageBuilder;
        private final Map<Integer, SavedRow> spilledRows = new HashMap<Integer, SavedRow>();
        private final boolean probeOnOuterSide;
        @Nullable
        private LookupSourceProvider lookupSourceProvider;
        @Nullable
        private JoinProbe probe;
        private long spillEpoch = 0L;
        private long joinPosition = -1L;
        private int joinSourcePositions;
        private boolean currentProbePositionProducedRow;
        private Optional<PartitioningSpiller> spiller = Optional.empty();
        private ListenableFuture<?> spillInProgress = Operator.NOT_BLOCKED;

        private PageJoiner(ProcessorContext processorContext, List<Type> probeTypes, List<Type> buildOutputTypes, LookupJoinOperators.JoinType joinType, HashGenerator hashGenerator, JoinProbe.JoinProbeFactory joinProbeFactory, LookupSourceFactory lookupSourceFactory, ListenableFuture<LookupSourceProvider> lookupSourceProvider, Optional<PartitioningSpillerFactory> partitioningSpillerFactory, JoinStatisticsCounter statisticsCounter, Iterator<SavedRow> savedRows) {
            Objects.requireNonNull(processorContext, "processorContext is null");
            this.probeTypes = Objects.requireNonNull(probeTypes, "probeTypes is null");
            this.joinProbeFactory = Objects.requireNonNull(joinProbeFactory, "joinProbeFactory is null");
            this.lookupSourceProviderFuture = Objects.requireNonNull(lookupSourceProvider, "lookupSourceProvider is null");
            this.partitioningSpillerFactory = Objects.requireNonNull(partitioningSpillerFactory, "partitioningSpillerFactory is null");
            this.spillContext = processorContext.getSpillContext();
            this.memoryTrackingContext = processorContext.getMemoryTrackingContext();
            this.statisticsCounter = Objects.requireNonNull(statisticsCounter, "statisticsCounter is null");
            this.yieldSignal = processorContext.getDriverYieldSignal();
            this.savedRows = Objects.requireNonNull(savedRows, "savedRows is null");
            this.partitionGenerator = Suppliers.memoize(() -> new LocalPartitionGenerator(hashGenerator, lookupSourceFactory.partitions()));
            this.pageBuilder = new LookupJoinPageBuilder(buildOutputTypes);
            this.probeOnOuterSide = joinType == LookupJoinOperators.JoinType.PROBE_OUTER || joinType == LookupJoinOperators.JoinType.FULL_OUTER;
        }

        @Override
        public WorkProcessor.TransformationState<Page> process(@Nullable Page probePage) {
            Optional<SpillInfoSnapshot> spillInfoSnapshotIfSpillChanged;
            boolean finishing;
            boolean bl = finishing = probePage == null;
            if (this.probe == null) {
                if (!finishing) {
                    this.probe = this.joinProbeFactory.createJoinProbe(probePage);
                    this.spillEpoch = 0L;
                } else if (this.savedRows.hasNext()) {
                    this.restoreProbe(this.savedRows.next());
                } else {
                    if (!this.spillInProgress.isDone()) {
                        return WorkProcessor.TransformationState.blocked(this.spillInProgress);
                    }
                    MoreFutures.checkSuccess(this.spillInProgress, (String)"spilling failed");
                    this.close();
                    return WorkProcessor.TransformationState.finished();
                }
            }
            Verify.verify((this.probe != null ? 1 : 0) != 0, (String)"no probe to work with", (Object[])new Object[0]);
            if (this.lookupSourceProvider == null) {
                if (!this.lookupSourceProviderFuture.isDone()) {
                    return WorkProcessor.TransformationState.blocked(this.lookupSourceProviderFuture);
                }
                this.lookupSourceProvider = Objects.requireNonNull((LookupSourceProvider)MoreFutures.getDone(this.lookupSourceProviderFuture));
                this.statisticsCounter.updateLookupSourcePositions(this.lookupSourceProvider.withLease(lookupSourceLease -> lookupSourceLease.getLookupSource().getJoinPositionCount()));
            }
            if ((spillInfoSnapshotIfSpillChanged = this.processProbe()).isPresent()) {
                if (!this.spillInProgress.isDone()) {
                    return WorkProcessor.TransformationState.blocked(this.spillInProgress);
                }
                MoreFutures.checkSuccess(this.spillInProgress, (String)"spilling failed");
                if (!this.pageBuilder.isEmpty()) {
                    return WorkProcessor.TransformationState.ofResult(this.buildOutputPage(), false);
                }
                this.spillJoinProbe(spillInfoSnapshotIfSpillChanged.get());
            }
            if (!this.probe.isFinished()) {
                if (this.pageBuilder.isFull()) {
                    return WorkProcessor.TransformationState.ofResult(this.buildOutputPage(), false);
                }
                return WorkProcessor.TransformationState.yield();
            }
            if (!this.pageBuilder.isEmpty() || finishing) {
                Page outputPage = this.buildOutputPage();
                this.probe = null;
                return WorkProcessor.TransformationState.ofResult(outputPage, !finishing);
            }
            this.probe = null;
            return WorkProcessor.TransformationState.needsMoreData();
        }

        private Optional<SpillInfoSnapshot> processProbe() {
            return this.lookupSourceProvider.withLease(lookupSourceLease -> {
                if (this.spillEpoch != lookupSourceLease.spillEpoch()) {
                    return Optional.of(SpillInfoSnapshot.from(lookupSourceLease));
                }
                this.processProbe(lookupSourceLease.getLookupSource());
                return Optional.empty();
            });
        }

        private void processProbe(LookupSource lookupSource) {
            do {
                if (this.probe.getPosition() < 0) continue;
                if (!this.joinCurrentPosition(lookupSource, this.yieldSignal)) break;
                if (!this.currentProbePositionProducedRow) {
                    this.currentProbePositionProducedRow = true;
                    if (!this.outerJoinCurrentPosition()) break;
                }
                this.statisticsCounter.recordProbe(this.joinSourcePositions);
            } while (this.advanceProbePosition(lookupSource) && !this.yieldSignal.isSet());
        }

        private boolean joinCurrentPosition(LookupSource lookupSource, DriverYieldSignal yieldSignal) {
            while (this.joinPosition >= 0L) {
                if (lookupSource.isJoinPositionEligible(this.joinPosition, this.probe.getPosition(), this.probe.getPage())) {
                    this.currentProbePositionProducedRow = true;
                    this.pageBuilder.appendRow(this.probe, lookupSource, this.joinPosition);
                    ++this.joinSourcePositions;
                }
                this.joinPosition = lookupSource.getNextJoinPosition(this.joinPosition, this.probe.getPosition(), this.probe.getPage());
                if (!yieldSignal.isSet() && !this.pageBuilder.isFull()) continue;
                return false;
            }
            return true;
        }

        private boolean outerJoinCurrentPosition() {
            if (this.probeOnOuterSide) {
                this.pageBuilder.appendNullForBuild(this.probe);
                return !this.pageBuilder.isFull();
            }
            return true;
        }

        private boolean advanceProbePosition(LookupSource lookupSource) {
            if (!this.probe.advanceNextPosition()) {
                return false;
            }
            this.joinPosition = this.probe.getCurrentJoinPosition(lookupSource);
            this.joinSourcePositions = 0;
            this.currentProbePositionProducedRow = false;
            return true;
        }

        private void spillJoinProbe(SpillInfoSnapshot spillInfoSnapshot) {
            Verify.verifyNotNull((Object)this.probe, (String)"probe is null", (Object[])new Object[0]);
            Verify.verify((boolean)this.pageBuilder.isEmpty(), (String)"pageBuilder must be flushed before spill", (Object[])new Object[0]);
            Preconditions.checkArgument((spillInfoSnapshot.getSpillEpoch() > 0L ? 1 : 0) != 0, (Object)"invalid spill epoch");
            if (this.probe.getPosition() < 0) {
                this.probe = this.joinProbeFactory.createJoinProbe(this.spillAndMaskSpilledPositions(this.probe.getPage(), spillInfoSnapshot));
            } else {
                int currentRowPartition = this.partitionGenerator.get().getPartition(this.probe.getPage(), this.probe.getPosition());
                boolean currentRowSpilled = spillInfoSnapshot.getSpillMask().test(currentRowPartition);
                if (currentRowSpilled) {
                    this.spilledRows.merge(currentRowPartition, new SavedRow(this.probe.getPage(), this.probe.getPosition(), this.getJoinPositionWithinPartition(), this.currentProbePositionProducedRow, this.joinSourcePositions), (oldValue, newValue) -> {
                        throw new IllegalStateException(String.format("Partition %s is already spilled", currentRowPartition));
                    });
                    Page remaining = this.pageTail(this.probe.getPage(), this.probe.getPosition() + 1);
                    this.probe = this.joinProbeFactory.createJoinProbe(this.spillAndMaskSpilledPositions(remaining, spillInfoSnapshot));
                    this.resetProbeRowState();
                } else {
                    Page remaining = this.pageTail(this.probe.getPage(), this.probe.getPosition());
                    this.probe = this.joinProbeFactory.createJoinProbe(this.spillAndMaskSpilledPositions(remaining, spillInfoSnapshot));
                    Verify.verify((boolean)this.probe.advanceNextPosition());
                }
            }
            this.spillEpoch = spillInfoSnapshot.getSpillEpoch();
        }

        private Page spillAndMaskSpilledPositions(Page page, SpillInfoSnapshot spillInfoSnapshot) {
            MoreFutures.checkSuccess(this.spillInProgress, (String)"spilling failed");
            if (this.spiller.isEmpty()) {
                Preconditions.checkState((boolean)this.partitioningSpillerFactory.isPresent(), (Object)"Spiller factory is not present");
                this.spiller = Optional.of(this.partitioningSpillerFactory.get().create(this.probeTypes, this.partitionGenerator.get(), this.spillContext.newLocalSpillContext(), this.memoryTrackingContext.newAggregateSystemMemoryContext()));
            }
            PartitioningSpiller.PartitioningSpillResult result = this.spiller.get().partitionAndSpill(page, spillInfoSnapshot.getSpillMask());
            this.spillInProgress = result.getSpillingFuture();
            return result.getRetained();
        }

        private long getJoinPositionWithinPartition() {
            if (this.joinPosition >= 0L) {
                return this.lookupSourceProvider.withLease(lookupSourceLease -> lookupSourceLease.getLookupSource().joinPositionWithinPartition(this.joinPosition));
            }
            return -1L;
        }

        private Page buildOutputPage() {
            Verify.verifyNotNull((Object)this.probe);
            Page outputPage = this.pageBuilder.build(this.probe);
            this.pageBuilder.reset();
            return outputPage;
        }

        private void resetProbeRowState() {
            this.joinPosition = -1L;
            this.joinSourcePositions = 0;
            this.currentProbePositionProducedRow = false;
        }

        private void restoreProbe(SavedRow savedRow) {
            this.probe = this.joinProbeFactory.createJoinProbe(savedRow.row);
            Verify.verify((boolean)this.probe.advanceNextPosition());
            this.joinPosition = savedRow.joinPositionWithinPartition;
            this.currentProbePositionProducedRow = savedRow.currentProbePositionProducedRow;
            this.joinSourcePositions = savedRow.joinSourcePositions;
            this.spillEpoch = 0L;
        }

        private Page pageTail(Page currentPage, int startAtPosition) {
            Verify.verify((currentPage.getPositionCount() - startAtPosition >= 0 ? 1 : 0) != 0);
            return currentPage.getRegion(startAtPosition, currentPage.getPositionCount() - startAtPosition);
        }

        private Map<Integer, SavedRow> getSpilledRows() {
            return this.spilledRows;
        }

        private Optional<PartitioningSpiller> getSpiller() {
            return this.spiller;
        }

        private void close() {
            this.pageBuilder.reset();
            MoreFutures.addSuccessCallback(this.lookupSourceProviderFuture, LookupSourceProvider::close);
        }
    }
}

