/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.prestosql.operator.NestedLoopJoinPages;
import io.prestosql.operator.OperatorContext;
import io.prestosql.spi.Page;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class NestedLoopJoinPagesBuilder {
    private final OperatorContext operatorContext;
    private int emptyChannelPositionCounter;
    private List<Page> pages;
    private boolean finished;
    private long estimatedSize;

    NestedLoopJoinPagesBuilder(OperatorContext operatorContext) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.pages = new ArrayList<Page>();
    }

    public void addPage(Page page) {
        this.checkNotFinished();
        if (page.getPositionCount() == 0) {
            return;
        }
        if (page.getChannelCount() == 0) {
            this.updatePagePositionCounter(page.getPositionCount());
            return;
        }
        this.pages.add(page);
        this.estimatedSize += page.getRetainedSizeInBytes();
    }

    private void updatePagePositionCounter(int positions) {
        long nextPositionCount = Math.addExact((long)this.emptyChannelPositionCounter, (long)positions);
        while (nextPositionCount >= 8192L) {
            nextPositionCount -= 8192L;
            Page flushed = new Page(8192);
            this.pages.add(flushed);
            this.estimatedSize += flushed.getRetainedSizeInBytes();
        }
        this.emptyChannelPositionCounter = Math.toIntExact(nextPositionCount);
    }

    public DataSize getEstimatedSize() {
        return DataSize.ofBytes((long)this.estimatedSize);
    }

    public void compact() {
        this.checkNotFinished();
        long estimatedSize = 0L;
        for (Page page : this.pages) {
            page.compact();
            estimatedSize += page.getRetainedSizeInBytes();
        }
        this.estimatedSize = estimatedSize;
    }

    public NestedLoopJoinPages build() {
        this.checkNotFinished();
        if (this.emptyChannelPositionCounter > 0) {
            Page output = new Page(this.emptyChannelPositionCounter);
            this.pages.add(output);
            this.estimatedSize += output.getRetainedSizeInBytes();
            this.emptyChannelPositionCounter = 0;
        }
        this.finished = true;
        this.pages = ImmutableList.copyOf(this.pages);
        return new NestedLoopJoinPages(this.pages, this.getEstimatedSize(), this.operatorContext);
    }

    private void checkNotFinished() {
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"NestedLoopJoinPagesBuilder is already finished");
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("estimatedSize", this.estimatedSize).add("pageCount", this.pages.size()).toString();
    }
}

