/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.annotations.VisibleForTesting;
import io.airlift.stats.cardinality.HyperLogLog;
import io.prestosql.operator.aggregation.state.BooleanDistinctState;
import io.prestosql.operator.aggregation.state.HyperLogLogState;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.AggregationState;
import io.prestosql.spi.function.BlockIndex;
import io.prestosql.spi.function.BlockPosition;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.Convention;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.OperatorDependency;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.type.BigintType;
import io.prestosql.util.Failures;
import java.lang.invoke.MethodHandle;

@AggregationFunction(value="approx_distinct")
public final class ApproximateCountDistinctAggregation {
    private static final double LOWEST_MAX_STANDARD_ERROR = 0.0040625;
    private static final double HIGHEST_MAX_STANDARD_ERROR = 0.26;

    private ApproximateCountDistinctAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState HyperLogLogState state, @BlockPosition @SqlType(value="unknown") Block block, @BlockIndex int index, @SqlType(value="double") double maxStandardError) {
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@OperatorDependency(operator=OperatorType.XX_HASH_64, argumentTypes={"T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle methodHandle, @AggregationState HyperLogLogState state, @SqlType(value="T") long value, @SqlType(value="double") double maxStandardError) {
        long hash;
        HyperLogLog hll = ApproximateCountDistinctAggregation.getOrCreateHyperLogLog(state, maxStandardError);
        state.addMemoryUsage(-hll.estimatedInMemorySize());
        try {
            hash = methodHandle.invokeExact(value);
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
        hll.addHash(hash);
        state.addMemoryUsage(hll.estimatedInMemorySize());
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@OperatorDependency(operator=OperatorType.XX_HASH_64, argumentTypes={"T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle methodHandle, @AggregationState HyperLogLogState state, @SqlType(value="T") double value, @SqlType(value="double") double maxStandardError) {
        long hash;
        HyperLogLog hll = ApproximateCountDistinctAggregation.getOrCreateHyperLogLog(state, maxStandardError);
        state.addMemoryUsage(-hll.estimatedInMemorySize());
        try {
            hash = methodHandle.invokeExact(value);
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
        hll.addHash(hash);
        state.addMemoryUsage(hll.estimatedInMemorySize());
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@OperatorDependency(operator=OperatorType.XX_HASH_64, argumentTypes={"T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle methodHandle, @AggregationState HyperLogLogState state, @SqlType(value="T") Object value, @SqlType(value="double") double maxStandardError) {
        long hash;
        HyperLogLog hll = ApproximateCountDistinctAggregation.getOrCreateHyperLogLog(state, maxStandardError);
        state.addMemoryUsage(-hll.estimatedInMemorySize());
        try {
            hash = methodHandle.invoke(value);
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
        hll.addHash(hash);
        state.addMemoryUsage(hll.estimatedInMemorySize());
    }

    @InputFunction
    public static void input(BooleanDistinctState state, @SqlType(value="boolean") boolean value, @SqlType(value="double") double maxStandardError) {
        byte newState = (byte)(state.getByte() | (value ? 1 : 2));
        state.setByte(newState);
    }

    private static HyperLogLog getOrCreateHyperLogLog(HyperLogLogState state, double maxStandardError) {
        HyperLogLog hll = state.getHyperLogLog();
        if (hll == null) {
            hll = HyperLogLog.newInstance((int)ApproximateCountDistinctAggregation.standardErrorToBuckets(maxStandardError));
            state.setHyperLogLog(hll);
            state.addMemoryUsage(hll.estimatedInMemorySize());
        }
        return hll;
    }

    @VisibleForTesting
    static int standardErrorToBuckets(double maxStandardError) {
        Failures.checkCondition(maxStandardError >= 0.0040625 && maxStandardError <= 0.26, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Max standard error must be in [%s, %s]: %s", 0.0040625, 0.26, maxStandardError);
        return ApproximateCountDistinctAggregation.log2Ceiling((int)Math.ceil(1.0816 / (maxStandardError * maxStandardError)));
    }

    private static int log2Ceiling(int value) {
        return Integer.highestOneBit(value - 1) << 1;
    }

    @CombineFunction
    public static void combineState(@AggregationState HyperLogLogState state, @AggregationState HyperLogLogState otherState) {
        HyperLogLog input = otherState.getHyperLogLog();
        HyperLogLog previous = state.getHyperLogLog();
        if (previous == null) {
            state.setHyperLogLog(input);
            state.addMemoryUsage(input.estimatedInMemorySize());
        } else {
            state.addMemoryUsage(-previous.estimatedInMemorySize());
            previous.mergeWith(input);
            state.addMemoryUsage(previous.estimatedInMemorySize());
        }
    }

    @CombineFunction
    public static void combineState(BooleanDistinctState state, BooleanDistinctState otherState) {
        state.setByte((byte)(state.getByte() | otherState.getByte()));
    }

    @OutputFunction(value="bigint")
    public static void evaluateFinal(@AggregationState HyperLogLogState state, BlockBuilder out) {
        HyperLogLog hyperLogLog = state.getHyperLogLog();
        if (hyperLogLog == null) {
            BigintType.BIGINT.writeLong(out, 0L);
        } else {
            BigintType.BIGINT.writeLong(out, hyperLogLog.cardinality());
        }
    }

    @OutputFunction(value="bigint")
    public static void evaluateFinal(BooleanDistinctState state, BlockBuilder out) {
        BigintType.BIGINT.writeLong(out, (long)Integer.bitCount(state.getByte()));
    }
}

