/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import io.prestosql.operator.aggregation.state.TriStateBooleanState;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.AggregationState;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.Type;

@AggregationFunction(value="bool_or")
public final class BooleanOrAggregation {
    private BooleanOrAggregation() {
    }

    @InputFunction
    public static void booleanOr(@AggregationState TriStateBooleanState state, @SqlType(value="boolean") boolean value) {
        if (value) {
            state.setByte((byte)1);
        } else if (state.getByte() == 0) {
            state.setByte((byte)-1);
        }
    }

    @CombineFunction
    public static void combine(@AggregationState TriStateBooleanState state, @AggregationState TriStateBooleanState otherState) {
        if (state.getByte() == 0) {
            state.setByte(otherState.getByte());
            return;
        }
        if (otherState.getByte() == 1) {
            state.setByte(otherState.getByte());
        }
    }

    @OutputFunction(value="boolean")
    public static void output(@AggregationState TriStateBooleanState state, BlockBuilder out) {
        TriStateBooleanState.write((Type)BooleanType.BOOLEAN, state, out);
    }
}

