/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import io.airlift.stats.TDigest;
import io.prestosql.operator.aggregation.state.StateCompiler;
import io.prestosql.operator.aggregation.state.TDigestState;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AccumulatorStateSerializer;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.AggregationState;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.SqlType;

@AggregationFunction(value="merge")
public final class MergeTDigestAggregation {
    private static final AccumulatorStateSerializer<TDigestState> serializer = StateCompiler.generateStateSerializer(TDigestState.class);

    private MergeTDigestAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState TDigestState state, @SqlType(value="tdigest") Object value) {
        MergeTDigestAggregation.merge(state, (TDigest)value);
    }

    @CombineFunction
    public static void combine(@AggregationState TDigestState state, @AggregationState TDigestState otherState) {
        MergeTDigestAggregation.merge(state, otherState.getTDigest());
    }

    private static void merge(@AggregationState TDigestState state, TDigest input) {
        if (input == null) {
            return;
        }
        TDigest previous = state.getTDigest();
        if (previous == null) {
            state.setTDigest(input);
            state.addMemoryUsage(input.estimatedInMemorySizeInBytes());
        } else {
            state.addMemoryUsage(-previous.estimatedInMemorySizeInBytes());
            previous.mergeWith(input);
            state.addMemoryUsage(previous.estimatedInMemorySizeInBytes());
        }
    }

    @OutputFunction(value="tdigest")
    public static void output(@AggregationState TDigestState state, BlockBuilder out) {
        serializer.serialize((Object)state, out);
    }
}

