/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation.histogram;

import io.prestosql.operator.aggregation.histogram.GroupedTypedHistogram;
import io.prestosql.operator.aggregation.histogram.HistogramState;
import io.prestosql.operator.aggregation.histogram.TypedHistogram;
import io.prestosql.operator.aggregation.state.AbstractGroupedAccumulatorState;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.Type;
import io.prestosql.type.BlockTypeOperators;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class GroupedHistogramState
extends AbstractGroupedAccumulatorState
implements HistogramState {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(GroupedHistogramState.class).instanceSize();
    private final Type type;
    private final BlockTypeOperators.BlockPositionEqual equalOperator;
    private final BlockTypeOperators.BlockPositionHashCode hashCodeOperator;
    private TypedHistogram typedHistogram;
    private long size;

    public GroupedHistogramState(Type keyType, BlockTypeOperators.BlockPositionEqual equalOperator, BlockTypeOperators.BlockPositionHashCode hashCodeOperator, int expectedEntriesCount) {
        this.type = Objects.requireNonNull(keyType, "keyType is null");
        this.equalOperator = Objects.requireNonNull(equalOperator, "equalOperator is null");
        this.hashCodeOperator = Objects.requireNonNull(hashCodeOperator, "hashCodeOperator is null");
        this.typedHistogram = new GroupedTypedHistogram(keyType, equalOperator, hashCodeOperator, expectedEntriesCount);
    }

    public void ensureCapacity(long size) {
        this.typedHistogram.ensureCapacity(size);
    }

    @Override
    public TypedHistogram get() {
        return this.typedHistogram.setGroupId(this.getGroupId());
    }

    @Override
    public void deserialize(Block block, int expectedSize) {
        this.typedHistogram = new GroupedTypedHistogram(this.getGroupId(), block, this.type, this.equalOperator, this.hashCodeOperator, expectedSize);
    }

    @Override
    public void addMemoryUsage(long memory) {
        this.size += memory;
    }

    public long getEstimatedSize() {
        return (long)INSTANCE_SIZE + this.size + this.typedHistogram.getEstimatedSize();
    }
}

