/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation.state;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.airlift.stats.TDigest;
import io.prestosql.operator.aggregation.state.TDigestAndPercentileArrayState;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AccumulatorStateSerializer;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import java.util.List;

public class TDigestAndPercentileArrayStateSerializer
implements AccumulatorStateSerializer<TDigestAndPercentileArrayState> {
    public Type getSerializedType() {
        return VarbinaryType.VARBINARY;
    }

    public void serialize(TDigestAndPercentileArrayState state, BlockBuilder out) {
        if (state.getDigest() == null) {
            out.appendNull();
        } else {
            Slice digest = state.getDigest().serialize();
            SliceOutput output = Slices.allocate((int)(4 + state.getPercentiles().size() * 8 + 4 + digest.length())).getOutput();
            List<Double> percentiles = state.getPercentiles();
            output.appendInt(percentiles.size());
            for (double percentile : percentiles) {
                output.appendDouble(percentile);
            }
            output.appendInt(digest.length());
            output.appendBytes(digest);
            VarbinaryType.VARBINARY.writeSlice(out, output.slice());
        }
    }

    public void deserialize(Block block, int index, TDigestAndPercentileArrayState state) {
        BasicSliceInput input = VarbinaryType.VARBINARY.getSlice(block, index).getInput();
        int numPercentiles = input.readInt();
        ImmutableList.Builder percentilesListBuilder = ImmutableList.builder();
        for (int i = 0; i < numPercentiles; ++i) {
            percentilesListBuilder.add((Object)input.readDouble());
        }
        state.setPercentiles((List<Double>)percentilesListBuilder.build());
        int length = input.readInt();
        state.setDigest(TDigest.deserialize((Slice)input.readSlice(length)));
        state.addMemoryUsage(state.getDigest().estimatedInMemorySizeInBytes());
    }
}

