/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.annotations;

import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.FunctionDependencies;
import io.prestosql.metadata.FunctionInvoker;
import io.prestosql.operator.annotations.ImplementationDependency;
import io.prestosql.spi.function.InvocationConvention;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleProxies;
import java.util.Objects;

public abstract class ScalarImplementationDependency
implements ImplementationDependency {
    private final InvocationConvention invocationConvention;
    private final Class<?> type;

    protected ScalarImplementationDependency(InvocationConvention invocationConvention, Class<?> type) {
        this.invocationConvention = Objects.requireNonNull(invocationConvention, "invocationConvention is null");
        this.type = Objects.requireNonNull(type, "type is null");
        if (invocationConvention.supportsInstanceFactor()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " does not support instance functions");
        }
    }

    protected abstract FunctionInvoker getInvoker(FunctionBinding var1, FunctionDependencies var2, InvocationConvention var3);

    @Override
    public Object resolve(FunctionBinding functionBinding, FunctionDependencies functionDependencies) {
        MethodHandle methodHandle = this.getInvoker(functionBinding, functionDependencies, this.invocationConvention).getMethodHandle();
        if (this.type == MethodHandle.class) {
            return methodHandle;
        }
        return MethodHandleProxies.asInterfaceInstance(this.type, methodHandle);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();
}

