/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.Convention;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.OperatorDependency;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlNullable;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.Type;
import io.prestosql.util.Failures;
import java.lang.invoke.MethodHandle;

@ScalarFunction(value="array_max")
@Description(value="Get maximum value of array")
public final class ArrayMaxFunction {
    private ArrayMaxFunction() {
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Long longArrayMax(@OperatorDependency(operator=OperatorType.COMPARISON, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        int selectedPosition = ArrayMaxFunction.findMaxArrayElement(compareMethodHandle, block);
        if (selectedPosition < 0) {
            return null;
        }
        return elementType.getLong(block, selectedPosition);
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Boolean booleanArrayMax(@OperatorDependency(operator=OperatorType.COMPARISON, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        int selectedPosition = ArrayMaxFunction.findMaxArrayElement(compareMethodHandle, block);
        if (selectedPosition < 0) {
            return null;
        }
        return elementType.getBoolean(block, selectedPosition);
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Double doubleArrayMax(@OperatorDependency(operator=OperatorType.COMPARISON, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        int selectedPosition = ArrayMaxFunction.findMaxArrayElement(compareMethodHandle, block);
        if (selectedPosition < 0) {
            return null;
        }
        return elementType.getDouble(block, selectedPosition);
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Object objectArrayMax(@OperatorDependency(operator=OperatorType.COMPARISON, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        int selectedPosition = ArrayMaxFunction.findMaxArrayElement(compareMethodHandle, block);
        if (selectedPosition < 0) {
            return null;
        }
        return elementType.getObject(block, selectedPosition);
    }

    private static int findMaxArrayElement(MethodHandle compareMethodHandle, Block block) {
        try {
            int selectedPosition = -1;
            for (int position = 0; position < block.getPositionCount(); ++position) {
                if (block.isNull(position)) {
                    return -1;
                }
                if (selectedPosition >= 0 && compareMethodHandle.invokeExact(block, position, block, selectedPosition) <= 0L) continue;
                selectedPosition = position;
            }
            return selectedPosition;
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }

    @SqlType(value="double")
    @SqlNullable
    public static Double doubleTypeArrayMax(@SqlType(value="array(double)") Block block) {
        if (block.getPositionCount() == 0) {
            return null;
        }
        int selectedPosition = -1;
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) {
                return null;
            }
            if (selectedPosition >= 0 && !ArrayMaxFunction.doubleGreater(DoubleType.DOUBLE.getDouble(block, position), DoubleType.DOUBLE.getDouble(block, selectedPosition))) continue;
            selectedPosition = position;
        }
        return DoubleType.DOUBLE.getDouble(block, selectedPosition);
    }

    private static boolean doubleGreater(double left, double right) {
        return left > right || Double.isNaN(right);
    }

    @SqlType(value="real")
    @SqlNullable
    public static Long realTypeArrayMax(@SqlType(value="array(real)") Block block) {
        if (block.getPositionCount() == 0) {
            return null;
        }
        int selectedPosition = -1;
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) {
                return null;
            }
            if (selectedPosition >= 0 && !ArrayMaxFunction.floatGreater(ArrayMaxFunction.getReal(block, position), ArrayMaxFunction.getReal(block, selectedPosition))) continue;
            selectedPosition = position;
        }
        return RealType.REAL.getLong(block, selectedPosition);
    }

    private static float getReal(Block block, int position) {
        return Float.intBitsToFloat((int)RealType.REAL.getLong(block, position));
    }

    private static boolean floatGreater(float left, float right) {
        return left > right || Float.isNaN(right);
    }
}

