/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.prestosql.operator.aggregation.TypedSet;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.Convention;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.OperatorDependency;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.type.BlockTypeOperators;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.concurrent.atomic.AtomicBoolean;

@ScalarFunction(value="array_union")
@Description(value="Union elements of the two given arrays")
public final class ArrayUnionFunction {
    private ArrayUnionFunction() {
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public static Block union(@TypeParameter(value="E") Type type, @OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"E", "E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) BlockTypeOperators.BlockPositionEqual elementEqual, @OperatorDependency(operator=OperatorType.HASH_CODE, argumentTypes={"E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) BlockTypeOperators.BlockPositionHashCode elementHashCode, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        int leftArrayCount = leftArray.getPositionCount();
        int rightArrayCount = rightArray.getPositionCount();
        TypedSet typedSet = TypedSet.createEqualityTypedSet(type, elementEqual, elementHashCode, leftArrayCount + rightArrayCount, "array_union");
        BlockBuilder distinctElementBlockBuilder = type.createBlockBuilder(null, leftArrayCount + rightArrayCount);
        ArrayUnionFunction.appendTypedArray(leftArray, type, typedSet, distinctElementBlockBuilder);
        ArrayUnionFunction.appendTypedArray(rightArray, type, typedSet, distinctElementBlockBuilder);
        return distinctElementBlockBuilder.build();
    }

    private static void appendTypedArray(Block array, Type type, TypedSet typedSet, BlockBuilder blockBuilder) {
        for (int i = 0; i < array.getPositionCount(); ++i) {
            if (typedSet.contains(array, i)) continue;
            typedSet.add(array, i);
            type.appendTo(array, i, blockBuilder);
        }
    }

    @SqlType(value="array(bigint)")
    public static Block bigintUnion(@SqlType(value="array(bigint)") Block leftArray, @SqlType(value="array(bigint)") Block rightArray) {
        int leftArrayCount = leftArray.getPositionCount();
        int rightArrayCount = rightArray.getPositionCount();
        LongOpenHashSet set = new LongOpenHashSet(leftArrayCount + rightArrayCount);
        BlockBuilder distinctElementBlockBuilder = BigintType.BIGINT.createBlockBuilder(null, leftArrayCount + rightArrayCount);
        AtomicBoolean containsNull = new AtomicBoolean(false);
        ArrayUnionFunction.appendBigintArray(leftArray, containsNull, (LongSet)set, distinctElementBlockBuilder);
        ArrayUnionFunction.appendBigintArray(rightArray, containsNull, (LongSet)set, distinctElementBlockBuilder);
        return distinctElementBlockBuilder.build();
    }

    private static void appendBigintArray(Block array, AtomicBoolean containsNull, LongSet set, BlockBuilder blockBuilder) {
        for (int i = 0; i < array.getPositionCount(); ++i) {
            if (array.isNull(i)) {
                if (containsNull.get()) continue;
                containsNull.set(true);
                blockBuilder.appendNull();
                continue;
            }
            long value = BigintType.BIGINT.getLong(array, i);
            if (!set.add(value)) continue;
            BigintType.BIGINT.writeLong(blockBuilder, value);
        }
    }
}

