/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ChoicesScalarFunctionImplementation;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.SingleMapBlock;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.TypeUtils;
import io.prestosql.sql.gen.lambda.LambdaFunctionInterface;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public final class MapZipWithFunction
extends SqlScalarFunction {
    public static final MapZipWithFunction MAP_ZIP_WITH_FUNCTION = new MapZipWithFunction();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapZipWithFunction.class, "mapZipWith", Type.class, Type.class, Type.class, MapType.class, Object.class, Block.class, Block.class, MapZipWithLambda.class);
    private static final MethodHandle STATE_FACTORY = Reflection.methodHandle(MapZipWithFunction.class, "createState", MapType.class);

    private MapZipWithFunction() {
        super(new FunctionMetadata(new Signature("map_zip_with", (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("K"), (Object)Signature.typeVariable("V1"), (Object)Signature.typeVariable("V2"), (Object)Signature.typeVariable("V3")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.mapType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]), (TypeSignature)new TypeSignature("V3", new TypeSignatureParameter[0])), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.mapType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]), (TypeSignature)new TypeSignature("V1", new TypeSignatureParameter[0])), (Object)TypeSignature.mapType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]), (TypeSignature)new TypeSignature("V2", new TypeSignatureParameter[0])), (Object)TypeSignature.functionType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]), (TypeSignature[])new TypeSignature[]{new TypeSignature("V1", new TypeSignatureParameter[0]), new TypeSignature("V2", new TypeSignatureParameter[0]), new TypeSignature("V3", new TypeSignatureParameter[0])})), false), false, (List<FunctionArgumentDefinition>)ImmutableList.of((Object)new FunctionArgumentDefinition(false), (Object)new FunctionArgumentDefinition(false), (Object)new FunctionArgumentDefinition(false)), false, false, "Merge two maps into a single map by applying the lambda function to the pair of values with the same key", FunctionKind.SCALAR));
    }

    @Override
    protected ScalarFunctionImplementation specialize(FunctionBinding functionBinding) {
        Type keyType = functionBinding.getTypeVariable("K");
        Type inputValueType1 = functionBinding.getTypeVariable("V1");
        Type inputValueType2 = functionBinding.getTypeVariable("V2");
        Type outputMapType = functionBinding.getBoundSignature().getReturnType();
        return new ChoicesScalarFunctionImplementation(functionBinding, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.FUNCTION), (List<Class<?>>)ImmutableList.of(MapZipWithLambda.class), METHOD_HANDLE.bindTo(keyType).bindTo(inputValueType1).bindTo(inputValueType2).bindTo(outputMapType), Optional.of(STATE_FACTORY.bindTo(outputMapType)));
    }

    public static Object createState(MapType mapType) {
        return new PageBuilder((List)ImmutableList.of((Object)mapType));
    }

    public static Block mapZipWith(Type keyType, Type leftValueType, Type rightValueType, MapType outputMapType, Object state, Block leftBlock, Block rightBlock, MapZipWithLambda function) {
        Object key;
        SingleMapBlock leftMapBlock = (SingleMapBlock)leftBlock;
        SingleMapBlock rightMapBlock = (SingleMapBlock)rightBlock;
        Type outputValueType = outputMapType.getValueType();
        PageBuilder pageBuilder = (PageBuilder)state;
        if (pageBuilder.isFull()) {
            pageBuilder.reset();
        }
        BlockBuilder mapBlockBuilder = pageBuilder.getBlockBuilder(0);
        BlockBuilder blockBuilder = mapBlockBuilder.beginBlockEntry();
        boolean[] keyFound = new boolean[rightMapBlock.getPositionCount()];
        for (int leftKeyPosition = 0; leftKeyPosition < leftMapBlock.getPositionCount(); leftKeyPosition += 2) {
            Object outputValue;
            key = TypeUtils.readNativeValue((Type)keyType, (Block)leftMapBlock, (int)leftKeyPosition);
            Object leftValue = TypeUtils.readNativeValue((Type)leftValueType, (Block)leftMapBlock, (int)(leftKeyPosition + 1));
            int rightValuePosition = rightMapBlock.seekKey(key);
            Object rightValue = null;
            if (rightValuePosition != -1) {
                rightValue = TypeUtils.readNativeValue((Type)rightValueType, (Block)rightMapBlock, (int)rightValuePosition);
                keyFound[rightValuePosition / 2] = true;
            }
            try {
                outputValue = function.apply(key, leftValue, rightValue);
            }
            catch (Throwable throwable) {
                mapBlockBuilder.closeEntry();
                pageBuilder.declarePosition();
                Throwables.throwIfUnchecked((Throwable)throwable);
                throw new RuntimeException(throwable);
            }
            keyType.appendTo((Block)leftMapBlock, leftKeyPosition, blockBuilder);
            TypeUtils.writeNativeValue((Type)outputValueType, (BlockBuilder)blockBuilder, (Object)outputValue);
        }
        for (int rightKeyPosition = 0; rightKeyPosition < rightMapBlock.getPositionCount(); rightKeyPosition += 2) {
            Object outputValue;
            if (keyFound[rightKeyPosition / 2]) continue;
            key = TypeUtils.readNativeValue((Type)keyType, (Block)rightMapBlock, (int)rightKeyPosition);
            Object rightValue = TypeUtils.readNativeValue((Type)rightValueType, (Block)rightMapBlock, (int)(rightKeyPosition + 1));
            try {
                outputValue = function.apply(key, null, rightValue);
            }
            catch (Throwable throwable) {
                mapBlockBuilder.closeEntry();
                pageBuilder.declarePosition();
                Throwables.throwIfUnchecked((Throwable)throwable);
                throw new RuntimeException(throwable);
            }
            keyType.appendTo((Block)rightMapBlock, rightKeyPosition, blockBuilder);
            TypeUtils.writeNativeValue((Type)outputValueType, (BlockBuilder)blockBuilder, (Object)outputValue);
        }
        mapBlockBuilder.closeEntry();
        pageBuilder.declarePosition();
        return outputMapType.getObject((Block)mapBlockBuilder, mapBlockBuilder.getPositionCount() - 1);
    }

    @FunctionalInterface
    public static interface MapZipWithLambda
    extends LambdaFunctionInterface {
        public Object apply(Object var1, Object var2, Object var3);
    }
}

