/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.FunctionDependencies;
import io.prestosql.metadata.FunctionDependencyDeclaration;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ChoicesScalarFunctionImplementation;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;

public class TryCastFunction
extends SqlScalarFunction {
    public static final TryCastFunction TRY_CAST = new TryCastFunction();

    public TryCastFunction() {
        super(new FunctionMetadata(new Signature("TRY_CAST", (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.castableToTypeParameter("F", new TypeSignature("T", new TypeSignatureParameter[0])), (Object)Signature.typeVariable("T")), (List<LongVariableConstraint>)ImmutableList.of(), new TypeSignature("T", new TypeSignatureParameter[0]), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("F", new TypeSignatureParameter[0])), false), true, (List<FunctionArgumentDefinition>)ImmutableList.of((Object)new FunctionArgumentDefinition(false)), true, true, "", FunctionKind.SCALAR));
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies() {
        return FunctionDependencyDeclaration.builder().addCastSignature(new TypeSignature("F", new TypeSignatureParameter[0]), new TypeSignature("T", new TypeSignatureParameter[0])).build();
    }

    @Override
    public ScalarFunctionImplementation specialize(FunctionBinding functionBinding, FunctionDependencies functionDependencies) {
        Type fromType = functionBinding.getTypeVariable("F");
        Type toType = functionBinding.getTypeVariable("T");
        Class returnType = Primitives.wrap((Class)toType.getJavaType());
        InvocationConvention invocationConvention = new InvocationConvention((List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, true, false);
        MethodHandle coercion = functionDependencies.getCastInvoker(fromType, toType, invocationConvention).getMethodHandle();
        coercion = coercion.asType(MethodType.methodType(returnType, coercion.type()));
        MethodHandle exceptionHandler = MethodHandles.dropArguments(MethodHandles.constant(returnType, null), 0, new Class[]{RuntimeException.class});
        MethodHandle tryCastHandle = MethodHandles.catchException(coercion, RuntimeException.class, exceptionHandler);
        return new ChoicesScalarFunctionImplementation(functionBinding, InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), tryCastHandle);
    }
}

