/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlNullable;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.function.TypeParameterSpecialization;
import io.prestosql.sql.gen.lambda.LambdaFunctionInterface;
import java.util.function.Supplier;

@Description(value="Internal try function for desugaring TRY")
@ScalarFunction(value="$internal$try", hidden=true, deterministic=false)
public final class TryFunction {
    public static final String NAME = "$internal$try";

    private TryFunction() {
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=long.class)
    @SqlNullable
    @SqlType(value="T")
    public static Long tryLong(@SqlType(value="function(T)") TryLongLambda function) {
        try {
            return function.apply();
        }
        catch (PrestoException e) {
            TryFunction.propagateIfUnhandled(e);
            return null;
        }
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=double.class)
    @SqlNullable
    @SqlType(value="T")
    public static Double tryDouble(@SqlType(value="function(T)") TryDoubleLambda function) {
        try {
            return function.apply();
        }
        catch (PrestoException e) {
            TryFunction.propagateIfUnhandled(e);
            return null;
        }
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=boolean.class)
    @SqlNullable
    @SqlType(value="T")
    public static Boolean tryBoolean(@SqlType(value="function(T)") TryBooleanLambda function) {
        try {
            return function.apply();
        }
        catch (PrestoException e) {
            TryFunction.propagateIfUnhandled(e);
            return null;
        }
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=Object.class)
    @SqlNullable
    @SqlType(value="T")
    public static Object tryObject(@SqlType(value="function(T)") TryObjectLambda function) {
        try {
            return function.apply();
        }
        catch (PrestoException e) {
            TryFunction.propagateIfUnhandled(e);
            return null;
        }
    }

    public static <T> T evaluate(Supplier<T> supplier, T defaultValue) {
        try {
            return supplier.get();
        }
        catch (PrestoException e) {
            TryFunction.propagateIfUnhandled(e);
            return defaultValue;
        }
    }

    private static void propagateIfUnhandled(PrestoException e) throws PrestoException {
        int errorCode = e.getErrorCode().getCode();
        if (errorCode == StandardErrorCode.DIVISION_BY_ZERO.toErrorCode().getCode() || errorCode == StandardErrorCode.INVALID_CAST_ARGUMENT.toErrorCode().getCode() || errorCode == StandardErrorCode.INVALID_FUNCTION_ARGUMENT.toErrorCode().getCode() || errorCode == StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE.toErrorCode().getCode()) {
            return;
        }
        throw e;
    }

    @FunctionalInterface
    public static interface TryObjectLambda
    extends LambdaFunctionInterface {
        public Object apply();
    }

    @FunctionalInterface
    public static interface TryBooleanLambda
    extends LambdaFunctionInterface {
        public Boolean apply();
    }

    @FunctionalInterface
    public static interface TryDoubleLambda
    extends LambdaFunctionInterface {
        public Double apply();
    }

    @FunctionalInterface
    public static interface TryLongLambda
    extends LambdaFunctionInterface {
        public Long apply();
    }
}

