/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.time;

import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.type.DateTimes;
import java.time.LocalDate;
import java.time.ZoneId;

@ScalarOperator(value=OperatorType.CAST)
public final class TimeToTimestampWithTimeZoneCast {
    private TimeToTimestampWithTimeZoneCast() {
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision) with time zone")
    public static long castToShort(@LiteralParameter(value="sourcePrecision") long sourcePrecision, @LiteralParameter(value="targetPrecision") long targetPrecision, ConnectorSession session, @SqlType(value="time(sourcePrecision)") long time) {
        ZoneId zoneId = session.getTimeZoneKey().getZoneId();
        long epochSeconds = TimeToTimestampWithTimeZoneCast.getEpochSeconds(session, time, zoneId);
        long picoFraction = TimeToTimestampWithTimeZoneCast.getPicoFraction(sourcePrecision, targetPrecision, time);
        long epochMillis = TimeToTimestampWithTimeZoneCast.computeEpochMillis(session, zoneId, epochSeconds, picoFraction);
        return DateTimeEncoding.packDateTimeWithZone((long)epochMillis, (TimeZoneKey)session.getTimeZoneKey());
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision) with time zone")
    public static LongTimestampWithTimeZone castToLong(@LiteralParameter(value="sourcePrecision") long sourcePrecision, @LiteralParameter(value="targetPrecision") long targetPrecision, ConnectorSession session, @SqlType(value="time(sourcePrecision)") long time) {
        ZoneId zoneId = session.getTimeZoneKey().getZoneId();
        long epochSeconds = TimeToTimestampWithTimeZoneCast.getEpochSeconds(session, time, zoneId);
        long picoFraction = TimeToTimestampWithTimeZoneCast.getPicoFraction(sourcePrecision, targetPrecision, time);
        long epochMillis = TimeToTimestampWithTimeZoneCast.computeEpochMillis(session, zoneId, epochSeconds, picoFraction);
        int picosOfMilli = (int)(picoFraction % 1000000000L);
        return LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)epochMillis, (int)picosOfMilli, (short)session.getTimeZoneKey().getKey());
    }

    private static long getEpochSeconds(ConnectorSession session, @SqlType(value="time(sourcePrecision)") long time, ZoneId zoneId) {
        long epochDay = LocalDate.ofInstant(session.getStart(), zoneId).toEpochDay();
        return Math.multiplyExact(epochDay, 86400L) + time / 1000000000000L;
    }

    private static long getPicoFraction(@LiteralParameter(value="sourcePrecision") long sourcePrecision, @LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="time(sourcePrecision)") long time) {
        long picoFraction = time % 1000000000000L;
        if (sourcePrecision > targetPrecision) {
            picoFraction = DateTimes.round(picoFraction, (int)(12L - targetPrecision));
        }
        return picoFraction;
    }

    private static long computeEpochMillis(ConnectorSession session, ZoneId zoneId, long epochSeconds, long picoFraction) {
        long milliFraction = DateTimes.rescale(picoFraction, 12, 3);
        long epochMillis = Math.multiplyExact(epochSeconds, 1000) + milliFraction;
        return epochMillis -= (long)(zoneId.getRules().getOffset(session.getStart()).getTotalSeconds() * 1000);
    }
}

