/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestamp;

@ScalarOperator(value=OperatorType.CAST)
@ScalarFunction(value="date")
public final class TimestampToDateCast {
    private TimestampToDateCast() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="date")
    public static long cast(ConnectorSession session, @SqlType(value="timestamp(p)") long timestamp) {
        return Math.floorDiv(timestamp, 86400000000L);
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="date")
    public static long cast(ConnectorSession session, @SqlType(value="timestamp(p)") LongTimestamp timestamp) {
        return TimestampToDateCast.cast(session, timestamp.getEpochMicros());
    }
}

