/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimeWithTimeZone;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.type.DateTimes;

@ScalarOperator(value=OperatorType.CAST)
public final class TimestampToTimeWithTimeZoneCast {
    private TimestampToTimeWithTimeZoneCast() {
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="time(targetPrecision) with time zone")
    public static long shortToShort(@LiteralParameter(value="targetPrecision") long targetPrecision, ConnectorSession session, @SqlType(value="timestamp(sourcePrecision)") long timestamp) {
        long nanos = Math.floorMod(timestamp, 86400000000L) * 1000L;
        nanos = DateTimes.round(nanos, (int)(9L - targetPrecision)) % 86400000000000L;
        return DateTimeEncoding.packTimeWithTimeZone((long)nanos, (int)DateTimes.getOffsetMinutes(session.getStart(), session.getTimeZoneKey()));
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="time(targetPrecision) with time zone")
    public static long longToShort(@LiteralParameter(value="targetPrecision") long targetPrecision, ConnectorSession session, @SqlType(value="timestamp(sourcePrecision)") LongTimestamp timestamp) {
        long picos = Math.floorMod(timestamp.getEpochMicros(), 86400000000L) * 1000000L + (long)timestamp.getPicosOfMicro();
        picos = DateTimes.round(picos, (int)(12L - targetPrecision));
        long nanos = DateTimes.rescale(picos, 12, 9) % 86400000000000L;
        return DateTimeEncoding.packTimeWithTimeZone((long)nanos, (int)DateTimes.getOffsetMinutes(session.getStart(), session.getTimeZoneKey()));
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="time(targetPrecision) with time zone")
    public static LongTimeWithTimeZone shortToLong(ConnectorSession session, @SqlType(value="timestamp(sourcePrecision)") long timestamp) {
        long picos = Math.floorMod(timestamp, 86400000000L) * 1000000L;
        return new LongTimeWithTimeZone(picos, DateTimes.getOffsetMinutes(session.getStart(), session.getTimeZoneKey()));
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="time(targetPrecision) with time zone")
    public static LongTimeWithTimeZone longToLong(@LiteralParameter(value="targetPrecision") long targetPrecision, ConnectorSession session, @SqlType(value="timestamp(sourcePrecision)") LongTimestamp timestamp) {
        long picos = Math.floorMod(timestamp.getEpochMicros(), 86400000000L) * 1000000L + (long)timestamp.getPicosOfMicro();
        picos = DateTimes.round(picos, (int)(12L - targetPrecision)) % 86400000000000000L;
        return new LongTimeWithTimeZone(picos, DateTimes.getOffsetMinutes(session.getStart(), session.getTimeZoneKey()));
    }
}

