/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.type.DateTimes;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

@ScalarOperator(value=OperatorType.CAST)
public final class TimestampToVarcharCast {
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss");

    private TimestampToVarcharCast() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar(x)")
    public static Slice cast(@LiteralParameter(value="p") long precision, @SqlType(value="timestamp(p)") long epochMicros) {
        return Slices.utf8Slice((String)DateTimes.formatTimestamp((int)precision, epochMicros, 0, ZoneOffset.UTC, TIMESTAMP_FORMATTER));
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar(x)")
    public static Slice cast(@LiteralParameter(value="p") long precision, @SqlType(value="timestamp(p)") LongTimestamp timestamp) {
        return Slices.utf8Slice((String)DateTimes.formatTimestamp((int)precision, timestamp.getEpochMicros(), timestamp.getPicosOfMicro(), ZoneOffset.UTC, TIMESTAMP_FORMATTER));
    }
}

