/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamptz;

import io.airlift.slice.Slice;
import io.prestosql.operator.scalar.DateTimeFunctions;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.type.DateTimes;
import io.prestosql.util.DateTimeZoneIndex;

@Description(value="Add the specified amount of time to the given timestamp")
@ScalarFunction(value="date_add")
public class DateAdd {
    private DateAdd() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p) with time zone")
    public static long add(@LiteralParameter(value="p") long precision, @SqlType(value="varchar(x)") Slice unit, @SqlType(value="bigint") long value, @SqlType(value="timestamp(p) with time zone") long packedEpochMillis) {
        long epochMillis = DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis);
        epochMillis = DateTimeFunctions.getTimestampField(DateTimeZoneIndex.unpackChronology(packedEpochMillis), unit).add(epochMillis, Math.toIntExact(value));
        epochMillis = DateTimes.round(epochMillis, (int)(3L - precision));
        return DateTimeEncoding.updateMillisUtc((long)epochMillis, (long)packedEpochMillis);
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p) with time zone")
    public static LongTimestampWithTimeZone add(@SqlType(value="varchar(x)") Slice unit, @SqlType(value="bigint") long value, @SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp) {
        long epochMillis = DateTimeFunctions.getTimestampField(DateTimeZoneIndex.unpackChronology(timestamp.getTimeZoneKey()), unit).add(timestamp.getEpochMillis(), Math.toIntExact(value));
        return LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)epochMillis, (int)timestamp.getPicosOfMilli(), (short)timestamp.getTimeZoneKey());
    }
}

