/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamptz;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.type.DateTimes;
import java.time.ZoneId;

@ScalarOperator(value=OperatorType.CAST)
public final class TimestampWithTimeZoneToVarcharCast {
    private TimestampWithTimeZoneToVarcharCast() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar(x)")
    public static Slice cast(@LiteralParameter(value="p") long precision, @SqlType(value="timestamp(p) with time zone") long packedEpochMillis) {
        long epochMillis = DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis);
        ZoneId zoneId = DateTimeEncoding.unpackZoneKey((long)packedEpochMillis).getZoneId();
        return Slices.utf8Slice((String)DateTimes.formatTimestampWithTimeZone((int)precision, epochMillis, 0, zoneId));
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar(x)")
    public static Slice cast(@LiteralParameter(value="p") long precision, @SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp) {
        return Slices.utf8Slice((String)DateTimes.formatTimestampWithTimeZone((int)precision, timestamp.getEpochMillis(), timestamp.getPicosOfMilli(), TimeZoneKey.getTimeZoneKey((short)timestamp.getTimeZoneKey()).getZoneId()));
    }
}

