/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamptz;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.type.Constraint;
import io.prestosql.type.DateTimes;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

@ScalarFunction(value="to_iso8601")
public final class ToIso8601 {
    private static final DateTimeFormatter ISO8601_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss");
    private static final String RESULT_LENGTH = "1 + 6 + 15 + min(p, 1) + p + 6";

    private ToIso8601() {
    }

    @LiteralParameters(value={"p", "n"})
    @SqlType(value="varchar(n)")
    @Constraint(variable="n", expression="1 + 6 + 15 + min(p, 1) + p + 6")
    public static Slice toIso8601(@LiteralParameter(value="p") long precision, @SqlType(value="timestamp(p) with time zone") long packedEpochMillis) {
        long epochMillis = DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis);
        ZoneId zoneId = DateTimeEncoding.unpackZoneKey((long)packedEpochMillis).getZoneId();
        return Slices.utf8Slice((String)ToIso8601.format((int)precision, epochMillis, 0, zoneId));
    }

    @LiteralParameters(value={"p", "n"})
    @SqlType(value="varchar(n)")
    @Constraint(variable="n", expression="1 + 6 + 15 + min(p, 1) + p + 6")
    public static Slice toIso8601(@LiteralParameter(value="p") long precision, @SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp) {
        return Slices.utf8Slice((String)ToIso8601.format((int)precision, timestamp.getEpochMillis(), timestamp.getPicosOfMilli(), TimeZoneKey.getTimeZoneKey((short)timestamp.getTimeZoneKey()).getZoneId()));
    }

    private static String format(int precision, long epochMillis, int picoSecondOfMilli, ZoneId zoneId) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMillis), zoneId);
        long picoFraction = (long)DateTimes.getMillisOfSecond(epochMillis) * 1000000000L + (long)picoSecondOfMilli;
        ZoneOffset offset = zoneId.getRules().getValidOffsets(dateTime).get(0);
        if (offset.getTotalSeconds() % 60 != 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, "Timezone with non-zero seconds offset cannot be rendered as ISO8601: " + offset.getId());
        }
        return DateTimes.formatTimestamp(precision, dateTime, picoFraction, ISO8601_FORMATTER, builder -> builder.append(offset));
    }
}

