/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timetz;

import io.airlift.slice.Slice;
import io.prestosql.operator.scalar.time.TimeOperators;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimeWithTimeZone;
import io.prestosql.type.DateTimes;
import java.util.Locale;

@Description(value="Add the specified amount of time to the given time")
@ScalarFunction(value="date_add")
public class DateAdd {
    private DateAdd() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="time(p) with time zone")
    public static long add(@LiteralParameter(value="p") long precision, @SqlType(value="varchar(x)") Slice unit, @SqlType(value="bigint") long value, @SqlType(value="time(p) with time zone") long packedTime) {
        long picos = DateAdd.add(DateTimeEncoding.unpackTimeNanos((long)packedTime) * 1000L, unit, value);
        if (precision <= 3L) {
            picos = DateTimes.round(picos, (int)(12L - precision)) % 86400000000000000L;
        }
        return DateTimeEncoding.packTimeWithTimeZone((long)(picos / 1000L), (int)DateTimeEncoding.unpackOffsetMinutes((long)packedTime));
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="time(p) with time zone")
    public static LongTimeWithTimeZone add(@SqlType(value="varchar(x)") Slice unit, @SqlType(value="bigint") long value, @SqlType(value="time(p) with time zone") LongTimeWithTimeZone time) {
        long picos = DateAdd.add(time.getPicoSeconds(), unit, value);
        return new LongTimeWithTimeZone(picos, time.getOffsetMinutes());
    }

    private static long add(long picos, Slice unit, long value) {
        String unitString;
        long delta = value;
        switch (unitString = unit.toStringAscii().toLowerCase(Locale.ENGLISH)) {
            case "millisecond": {
                delta = delta % 86400000L * 1000000000L;
                break;
            }
            case "second": {
                delta = delta % 86400L * 1000000000000L;
                break;
            }
            case "minute": {
                delta = delta % 1440L * 60000000000000L;
                break;
            }
            case "hour": {
                delta = delta % 24L * 3600000000000000L;
                break;
            }
            default: {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "'" + unitString + "' is not a valid Time field");
            }
        }
        return TimeOperators.add(picos, delta);
    }
}

