/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.security;

import com.google.common.base.Verify;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.security.AccessControl;
import io.prestosql.security.DenyAllAccessControl;
import io.prestosql.security.SecurityContext;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.security.AccessDeniedException;
import io.prestosql.spi.security.Identity;
import io.prestosql.spi.security.ViewExpression;
import io.prestosql.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ViewAccessControl
extends DenyAllAccessControl {
    private final AccessControl delegate;
    private final Identity invoker;

    public ViewAccessControl(AccessControl delegate, Identity invoker) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.invoker = Objects.requireNonNull(invoker, "invoker is null");
    }

    @Override
    public void checkCanSelectFromColumns(SecurityContext context, QualifiedObjectName tableName, Set<String> columnNames) {
        ViewAccessControl.wrapAccessDeniedException(() -> this.delegate.checkCanCreateViewWithSelectFromColumns(context, tableName, columnNames));
    }

    @Override
    public void checkCanCreateViewWithSelectFromColumns(SecurityContext context, QualifiedObjectName tableName, Set<String> columnNames) {
        ViewAccessControl.wrapAccessDeniedException(() -> this.delegate.checkCanCreateViewWithSelectFromColumns(context, tableName, columnNames));
    }

    @Override
    public void checkCanExecuteFunction(SecurityContext context, String functionName) {
        ViewAccessControl.wrapAccessDeniedException(() -> this.delegate.checkCanGrantExecuteFunctionPrivilege(context, functionName, this.invoker, false));
    }

    @Override
    public void checkCanGrantExecuteFunctionPrivilege(SecurityContext context, String functionName, Identity grantee, boolean grantOption) {
        ViewAccessControl.wrapAccessDeniedException(() -> this.delegate.checkCanGrantExecuteFunctionPrivilege(context, functionName, grantee, grantOption));
    }

    @Override
    public List<ViewExpression> getRowFilters(SecurityContext context, QualifiedObjectName tableName) {
        return this.delegate.getRowFilters(context, tableName);
    }

    @Override
    public List<ViewExpression> getColumnMasks(SecurityContext context, QualifiedObjectName tableName, String columnName, Type type) {
        return this.delegate.getColumnMasks(context, tableName, columnName, type);
    }

    private static void wrapAccessDeniedException(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (AccessDeniedException e) {
            String prefix = "Access Denied: ";
            Verify.verify((boolean)e.getMessage().startsWith(prefix));
            String msg = e.getMessage().substring(prefix.length());
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, prefix + "View owner does not have sufficient privileges: " + msg, (Throwable)e);
        }
    }
}

