/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.security.oauth2;

import io.airlift.log.Logger;
import io.prestosql.server.security.ResourceSecurity;
import io.prestosql.server.security.oauth2.ChallengeFailedException;
import io.prestosql.server.security.oauth2.OAuth2Service;
import io.prestosql.server.ui.OAuthWebUiCookie;
import java.net.URI;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

@Path(value="/oauth2/callback")
public class OAuth2CallbackResource {
    private static final Logger LOG = Logger.get(OAuth2CallbackResource.class);
    public static final String CALLBACK_ENDPOINT = "/oauth2/callback";
    private final OAuth2Service service;

    @Inject
    public OAuth2CallbackResource(OAuth2Service service) {
        this.service = Objects.requireNonNull(service, "service is null");
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    @GET
    @Produces(value={"text/html"})
    public Response callback(@QueryParam(value="state") String state, @QueryParam(value="code") String code, @QueryParam(value="error") String error, @QueryParam(value="error_description") String errorDescription, @QueryParam(value="error_uri") String errorUri, @Context UriInfo uriInfo, @Context SecurityContext securityContext) {
        OAuth2Service.OAuthResult result;
        if (error != null) {
            LOG.debug("OAuth server returned an error: error=%s, error_description=%s, error_uri=%s, state=%s", new Object[]{error, errorDescription, errorUri, state});
            return Response.ok().entity((Object)this.service.getCallbackErrorHtml(error)).build();
        }
        try {
            result = this.service.finishChallenge(state, code, uriInfo.getBaseUri().resolve(CALLBACK_ENDPOINT));
        }
        catch (ChallengeFailedException | RuntimeException e) {
            LOG.debug((Throwable)e, "Authentication response could not be verified: state=%s", new Object[]{state});
            return Response.ok().entity((Object)this.service.getInternalFailureHtml("Authentication response could not be verified")).build();
        }
        return Response.seeOther((URI)URI.create("/ui/")).cookie(new NewCookie[]{OAuthWebUiCookie.create(result.getAccessToken(), result.getTokenExpiration(), securityContext.isSecure())}).build();
    }
}

