/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.ui;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtException;
import io.prestosql.server.ServletSecurityUtils;
import io.prestosql.server.security.UserMapping;
import io.prestosql.server.security.UserMappingException;
import io.prestosql.server.security.oauth2.OAuth2Config;
import io.prestosql.server.security.oauth2.OAuth2Service;
import io.prestosql.server.ui.FormWebUiAuthenticationFilter;
import io.prestosql.server.ui.OAuthWebUiCookie;
import io.prestosql.server.ui.WebUiAuthenticationFilter;
import io.prestosql.spi.security.BasicPrincipal;
import io.prestosql.spi.security.Identity;
import java.net.URI;
import java.security.Principal;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;

public class OAuth2WebUiAuthenticationFilter
implements WebUiAuthenticationFilter {
    private static final Logger LOG = Logger.get(OAuth2WebUiAuthenticationFilter.class);
    private final OAuth2Service service;
    private final UserMapping userMapping;

    @Inject
    public OAuth2WebUiAuthenticationFilter(OAuth2Service service, OAuth2Config oauth2Config) {
        this.service = Objects.requireNonNull(service, "service is null");
        Objects.requireNonNull(oauth2Config, "oauth2Config is null");
        this.userMapping = UserMapping.createUserMapping(oauth2Config.getUserMappingPattern(), oauth2Config.getUserMappingFile());
    }

    public void filter(ContainerRequestContext request) {
        String path = request.getUriInfo().getRequestUri().getPath();
        if (path.equals("/ui/disabled.html")) {
            return;
        }
        if (!request.getSecurityContext().isSecure()) {
            if (path.startsWith("/ui/api/")) {
                ServletSecurityUtils.sendWwwAuthenticate(request, "Unauthorized", (Collection<String>)ImmutableSet.of((Object)"Presto-Form-Login"));
                return;
            }
            request.abortWith(Response.seeOther((URI)FormWebUiAuthenticationFilter.DISABLED_LOCATION_URI).build());
            return;
        }
        Optional<String> subject = this.getAccessToken(request).map(token -> ((Claims)token.getBody()).getSubject());
        if (subject.isEmpty()) {
            this.needAuthentication(request);
            return;
        }
        try {
            ServletSecurityUtils.setAuthenticatedIdentity(request, Identity.forUser((String)this.userMapping.mapUser(subject.get())).withPrincipal((Principal)new BasicPrincipal(subject.get())).build());
        }
        catch (UserMappingException e) {
            ServletSecurityUtils.sendErrorMessage(request, Response.Status.UNAUTHORIZED, (String)MoreObjects.firstNonNull((Object)e.getMessage(), (Object)"Unauthorized"));
        }
    }

    private Optional<Jws<Claims>> getAccessToken(ContainerRequestContext request) {
        return OAuthWebUiCookie.read(request).flatMap(token -> {
            try {
                return Optional.ofNullable(this.service.parseClaimsJws((String)token));
            }
            catch (JwtException | IllegalArgumentException e) {
                LOG.debug("Unable to parse JWT token: " + e.getMessage(), new Object[]{e});
                return Optional.empty();
            }
        });
    }

    private void needAuthentication(ContainerRequestContext request) {
        URI redirectLocation = this.service.startChallenge(request.getUriInfo().getBaseUri().resolve("/oauth2/callback"));
        request.abortWith(Response.seeOther((URI)redirectLocation).build());
    }
}

