/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.analyzer;

import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.sql.analyzer.ExpressionTreeUtils;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.QualifiedName;

public final class SemanticExceptions {
    private SemanticExceptions() {
    }

    public static PrestoException missingAttributeException(Expression node, QualifiedName name) {
        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)node, "Column '%s' cannot be resolved", name);
    }

    public static PrestoException ambiguousAttributeException(Expression node, QualifiedName name) {
        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_NAME, (Node)node, "Column '%s' is ambiguous", name);
    }

    public static PrestoException semanticException(ErrorCodeSupplier code, Node node, String format, Object ... args) {
        return SemanticExceptions.semanticException(code, node, null, format, args);
    }

    public static PrestoException semanticException(ErrorCodeSupplier code, Node node, Throwable cause, String format, Object ... args) {
        throw new PrestoException(code, ExpressionTreeUtils.extractLocation(node), String.format(format, args), cause);
    }
}

