/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.analyzer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.type.NamedTypeSignature;
import io.prestosql.spi.type.RowFieldName;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.analyzer.SemanticExceptions;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.tree.DataType;
import io.prestosql.sql.tree.DataTypeParameter;
import io.prestosql.sql.tree.DateTimeDataType;
import io.prestosql.sql.tree.GenericDataType;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.IntervalDayTimeDataType;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NumericParameter;
import io.prestosql.sql.tree.RowDataType;
import io.prestosql.sql.tree.TypeParameter;
import io.prestosql.type.IntervalDayTimeType;
import io.prestosql.type.IntervalYearMonthType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.assertj.core.util.VisibleForTesting;

public class TypeSignatureTranslator {
    private static final SqlParser SQL_PARSER = new SqlParser();

    private TypeSignatureTranslator() {
    }

    public static DataType toSqlType(Type type) {
        return TypeSignatureTranslator.toDataType(type.getTypeSignature());
    }

    public static TypeSignature toTypeSignature(DataType type) {
        return TypeSignatureTranslator.toTypeSignature(type, Set.of());
    }

    private static TypeSignature toTypeSignature(DataType type, Set<String> typeVariables) {
        if (type instanceof DateTimeDataType) {
            return TypeSignatureTranslator.toTypeSignature((DateTimeDataType)type, typeVariables);
        }
        if (type instanceof IntervalDayTimeDataType) {
            return TypeSignatureTranslator.toTypeSignature((IntervalDayTimeDataType)type);
        }
        if (type instanceof RowDataType) {
            return TypeSignatureTranslator.toTypeSignature((RowDataType)type, typeVariables);
        }
        if (type instanceof GenericDataType) {
            return TypeSignatureTranslator.toTypeSignature((GenericDataType)type, typeVariables);
        }
        throw new UnsupportedOperationException("Unsupported DataType: " + type.getClass().getName());
    }

    public static TypeSignature parseTypeSignature(String signature, Set<String> typeVariables) {
        TreeSet<String> variables = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        variables.addAll(typeVariables);
        return TypeSignatureTranslator.toTypeSignature(SQL_PARSER.createType(signature), variables);
    }

    private static TypeSignature toTypeSignature(GenericDataType type, Set<String> typeVariables) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        if (type.getName().getValue().equalsIgnoreCase("varchar") && type.getArguments().isEmpty()) {
            return VarcharType.VARCHAR.getTypeSignature();
        }
        Preconditions.checkArgument((!typeVariables.contains(type.getName().getValue()) ? 1 : 0) != 0, (Object)"Base type name cannot be a type variable");
        for (DataTypeParameter parameter : type.getArguments()) {
            String value;
            if (parameter instanceof NumericParameter) {
                value = ((NumericParameter)parameter).getValue();
                try {
                    parameters.add((Object)TypeSignatureParameter.numericParameter((long)Long.parseLong(value)));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, (Node)parameter, "Invalid type parameter: %s", value);
                }
            }
            if (parameter instanceof TypeParameter) {
                value = ((TypeParameter)parameter).getValue();
                if (value instanceof GenericDataType && ((GenericDataType)value).getArguments().isEmpty() && typeVariables.contains(((GenericDataType)value).getName().getValue())) {
                    parameters.add((Object)TypeSignatureParameter.typeVariable((String)((GenericDataType)value).getName().getValue()));
                    continue;
                }
                parameters.add((Object)TypeSignatureParameter.typeParameter((TypeSignature)TypeSignatureTranslator.toTypeSignature((DataType)value, typeVariables)));
                continue;
            }
            throw new UnsupportedOperationException("Unsupported type parameter kind: " + parameter.getClass().getName());
        }
        return new TypeSignature(TypeSignatureTranslator.canonicalize(type.getName()), (List)parameters.build());
    }

    private static TypeSignature toTypeSignature(RowDataType type, Set<String> typeVariables) {
        List parameters = (List)type.getFields().stream().map(field -> TypeSignatureParameter.namedTypeParameter((NamedTypeSignature)new NamedTypeSignature(field.getName().map(TypeSignatureTranslator::canonicalize).map(RowFieldName::new), TypeSignatureTranslator.toTypeSignature(field.getType(), typeVariables)))).collect(ImmutableList.toImmutableList());
        return new TypeSignature("row", parameters);
    }

    private static TypeSignature toTypeSignature(IntervalDayTimeDataType type) {
        if (type.getFrom() == IntervalDayTimeDataType.Field.YEAR && type.getTo() == IntervalDayTimeDataType.Field.MONTH) {
            return IntervalYearMonthType.INTERVAL_YEAR_MONTH.getTypeSignature();
        }
        if (type.getFrom() == IntervalDayTimeDataType.Field.DAY && type.getTo() == IntervalDayTimeDataType.Field.SECOND) {
            return IntervalDayTimeType.INTERVAL_DAY_TIME.getTypeSignature();
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("INTERVAL %s TO %s type not supported", type.getFrom(), type.getTo()));
    }

    private static TypeSignature toTypeSignature(DateTimeDataType type, Set<String> typeVariables) {
        String base;
        boolean withTimeZone = type.isWithTimeZone();
        switch (type.getType()) {
            case TIMESTAMP: {
                if (withTimeZone) {
                    base = "timestamp with time zone";
                    break;
                }
                base = "timestamp";
                break;
            }
            case TIME: {
                if (withTimeZone) {
                    base = "time with time zone";
                    break;
                }
                base = "time";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown dateTime type: " + type.getType());
            }
        }
        return new TypeSignature(base, TypeSignatureTranslator.translateParameters(type, typeVariables));
    }

    private static List<TypeSignatureParameter> translateParameters(DateTimeDataType type, Set<String> typeVariables) {
        ArrayList<TypeSignatureParameter> parameters = new ArrayList<TypeSignatureParameter>();
        if (type.getPrecision().isPresent()) {
            DataTypeParameter precision = (DataTypeParameter)type.getPrecision().get();
            if (precision instanceof NumericParameter) {
                parameters.add(TypeSignatureParameter.numericParameter((long)Long.parseLong(((NumericParameter)precision).getValue())));
            } else if (precision instanceof TypeParameter) {
                DataType typeVariable = ((TypeParameter)precision).getValue();
                Preconditions.checkArgument((typeVariable instanceof GenericDataType && ((GenericDataType)typeVariable).getArguments().isEmpty() ? 1 : 0) != 0);
                String variable = ((GenericDataType)typeVariable).getName().getValue();
                Preconditions.checkArgument((boolean)typeVariables.contains(variable), (String)"Parameter to datetime type must be either a number or a type variable: %s", (Object)variable);
                parameters.add(TypeSignatureParameter.typeVariable((String)variable));
            }
        }
        return parameters;
    }

    private static String canonicalize(Identifier identifier) {
        if (identifier.isDelimited()) {
            return identifier.getValue();
        }
        return identifier.getValue().toLowerCase(Locale.ENGLISH);
    }

    @VisibleForTesting
    static DataType toDataType(TypeSignature typeSignature) {
        switch (typeSignature.getBase()) {
            case "interval year to month": {
                return new IntervalDayTimeDataType(Optional.empty(), IntervalDayTimeDataType.Field.YEAR, IntervalDayTimeDataType.Field.MONTH);
            }
            case "interval day to second": {
                return new IntervalDayTimeDataType(Optional.empty(), IntervalDayTimeDataType.Field.DAY, IntervalDayTimeDataType.Field.SECOND);
            }
            case "timestamp with time zone": {
                if (typeSignature.getParameters().isEmpty()) {
                    return new DateTimeDataType(Optional.empty(), DateTimeDataType.Type.TIMESTAMP, true, Optional.empty());
                }
                Optional<DataTypeParameter> argument = typeSignature.getParameters().stream().map(TypeSignatureTranslator::toTypeParameter).findAny();
                return new DateTimeDataType(Optional.empty(), DateTimeDataType.Type.TIMESTAMP, true, argument);
            }
            case "timestamp": {
                if (typeSignature.getParameters().isEmpty()) {
                    return new DateTimeDataType(Optional.empty(), DateTimeDataType.Type.TIMESTAMP, false, Optional.empty());
                }
                Optional<DataTypeParameter> argument = typeSignature.getParameters().stream().map(TypeSignatureTranslator::toTypeParameter).findAny();
                return new DateTimeDataType(Optional.empty(), DateTimeDataType.Type.TIMESTAMP, false, argument);
            }
            case "time with time zone": {
                if (typeSignature.getParameters().isEmpty()) {
                    return new DateTimeDataType(Optional.empty(), DateTimeDataType.Type.TIME, true, Optional.empty());
                }
                Optional<DataTypeParameter> argument = typeSignature.getParameters().stream().map(TypeSignatureTranslator::toTypeParameter).findAny();
                return new DateTimeDataType(Optional.empty(), DateTimeDataType.Type.TIME, true, argument);
            }
            case "time": {
                if (typeSignature.getParameters().isEmpty()) {
                    return new DateTimeDataType(Optional.empty(), DateTimeDataType.Type.TIME, false, Optional.empty());
                }
                Optional<DataTypeParameter> argument = typeSignature.getParameters().stream().map(TypeSignatureTranslator::toTypeParameter).findAny();
                return new DateTimeDataType(Optional.empty(), DateTimeDataType.Type.TIME, false, argument);
            }
            case "row": {
                return new RowDataType(Optional.empty(), (List)typeSignature.getParameters().stream().map(parameter -> new RowDataType.Field(Optional.empty(), parameter.getNamedTypeSignature().getFieldName().map(fieldName -> new Identifier(fieldName.getName())), TypeSignatureTranslator.toDataType(parameter.getNamedTypeSignature().getTypeSignature()))).collect(ImmutableList.toImmutableList()));
            }
            case "varchar": {
                return new GenericDataType(Optional.empty(), new Identifier(typeSignature.getBase(), false), (List)typeSignature.getParameters().stream().filter(parameter -> parameter.getLongLiteral() != Integer.MAX_VALUE).map(parameter -> new NumericParameter(Optional.empty(), String.valueOf(parameter))).collect(ImmutableList.toImmutableList()));
            }
        }
        return new GenericDataType(Optional.empty(), new Identifier(typeSignature.getBase(), false), (List)typeSignature.getParameters().stream().map(TypeSignatureTranslator::toTypeParameter).collect(ImmutableList.toImmutableList()));
    }

    private static DataTypeParameter toTypeParameter(TypeSignatureParameter parameter) {
        switch (parameter.getKind()) {
            case LONG: {
                return new NumericParameter(Optional.empty(), String.valueOf(parameter.getLongLiteral()));
            }
            case TYPE: {
                return new TypeParameter(TypeSignatureTranslator.toDataType(parameter.getTypeSignature()));
            }
        }
        throw new UnsupportedOperationException("Unsupported parameter kind");
    }
}

