/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.gen;

import com.google.common.base.Preconditions;
import io.airlift.bytecode.BytecodeNode;
import io.prestosql.sql.gen.BytecodeGenerator;
import io.prestosql.sql.gen.BytecodeGeneratorContext;
import io.prestosql.sql.gen.LambdaBytecodeGenerator;
import io.prestosql.sql.relational.LambdaDefinitionExpression;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.sql.relational.SpecialForm;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BindCodeGenerator
implements BytecodeGenerator {
    private final Class<?> lambdaInterface;
    private final LambdaBytecodeGenerator.CompiledLambda compiledLambda;
    private final List<RowExpression> captureExpressions;

    public BindCodeGenerator(SpecialForm specialForm, Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> compiledLambdaMap, Class<?> lambdaInterface) {
        Objects.requireNonNull(specialForm, "specialForm is null");
        Objects.requireNonNull(compiledLambdaMap, "compiledLambdaMap is null");
        this.lambdaInterface = Objects.requireNonNull(lambdaInterface, "lambdaInterface is null");
        List<RowExpression> arguments = specialForm.getArguments();
        int numCaptures = arguments.size() - 1;
        LambdaDefinitionExpression lambda = (LambdaDefinitionExpression)arguments.get(numCaptures);
        Preconditions.checkArgument((boolean)compiledLambdaMap.containsKey(lambda), (Object)"lambda expressions map does not contain this lambda definition");
        this.compiledLambda = compiledLambdaMap.get(lambda);
        this.captureExpressions = arguments.subList(0, numCaptures);
    }

    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext context) {
        return LambdaBytecodeGenerator.generateLambda(context, this.captureExpressions, this.compiledLambda, this.lambdaInterface);
    }
}

