/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.gen;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.BytecodeVisitor;
import io.airlift.bytecode.MethodGenerationContext;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.slice.Slice;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.gen.CallSiteBinder;
import io.prestosql.sql.gen.SqlTypeBytecodeExpression;
import io.prestosql.sql.relational.CallExpression;
import io.prestosql.sql.relational.ConstantExpression;
import io.prestosql.sql.relational.InputReferenceExpression;
import io.prestosql.sql.relational.LambdaDefinitionExpression;
import io.prestosql.sql.relational.RowExpressionVisitor;
import io.prestosql.sql.relational.SpecialForm;
import io.prestosql.sql.relational.VariableReferenceExpression;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import org.objectweb.asm.MethodVisitor;

class InputReferenceCompiler
implements RowExpressionVisitor<BytecodeNode, Scope> {
    private final BiFunction<Scope, Integer, BytecodeExpression> blockResolver;
    private final BiFunction<Scope, Integer, BytecodeExpression> positionResolver;
    private final CallSiteBinder callSiteBinder;

    public InputReferenceCompiler(BiFunction<Scope, Integer, BytecodeExpression> blockResolver, BiFunction<Scope, Integer, BytecodeExpression> positionResolver, CallSiteBinder callSiteBinder) {
        this.blockResolver = Objects.requireNonNull(blockResolver, "blockResolver is null");
        this.positionResolver = Objects.requireNonNull(positionResolver, "positionResolver is null");
        this.callSiteBinder = Objects.requireNonNull(callSiteBinder, "callSiteBinder is null");
    }

    public static BytecodeNode generateInputReference(CallSiteBinder callSiteBinder, Scope scope, Type type, BytecodeExpression block, BytecodeExpression position) {
        return new InputReferenceNode(callSiteBinder, scope, type, block, position);
    }

    @Override
    public BytecodeNode visitInputReference(InputReferenceExpression node, Scope scope) {
        int field = node.getField();
        Type type = node.getType();
        BytecodeExpression block = this.blockResolver.apply(scope, field);
        BytecodeExpression position = this.positionResolver.apply(scope, field);
        return InputReferenceCompiler.generateInputReference(this.callSiteBinder, scope, type, block, position);
    }

    @Override
    public BytecodeNode visitCall(CallExpression call, Scope scope) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public BytecodeNode visitSpecialForm(SpecialForm specialForm, Scope context) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public BytecodeNode visitConstant(ConstantExpression literal, Scope scope) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public BytecodeNode visitLambda(LambdaDefinitionExpression lambda, Scope context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BytecodeNode visitVariableReference(VariableReferenceExpression reference, Scope context) {
        throw new UnsupportedOperationException();
    }

    static class InputReferenceNode
    implements BytecodeNode {
        private final BytecodeNode body;
        private final BytecodeExpression block;
        private final BytecodeExpression position;

        private InputReferenceNode(CallSiteBinder callSiteBinder, Scope scope, Type type, BytecodeExpression block, BytecodeExpression position) {
            Variable wasNullVariable = scope.getVariable("wasNull");
            Class<Object> callType = type.getJavaType();
            if (!callType.isPrimitive() && callType != Slice.class) {
                callType = Object.class;
            }
            IfStatement ifStatement = new IfStatement();
            ifStatement.condition((BytecodeNode)block.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{position}));
            ifStatement.ifTrue().putVariable(wasNullVariable, true).pushJavaDefault(callType);
            String methodName = "get" + Primitives.wrap(callType).getSimpleName();
            BytecodeExpression value = SqlTypeBytecodeExpression.constantType(callSiteBinder, type).invoke(methodName, callType, new BytecodeExpression[]{block, position});
            if (callType != type.getJavaType()) {
                value = value.cast(type.getJavaType());
            }
            ifStatement.ifFalse((BytecodeNode)value);
            this.body = ifStatement;
            this.block = block;
            this.position = position;
        }

        public List<BytecodeNode> getChildNodes() {
            return ImmutableList.of();
        }

        public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
            this.body.accept(visitor, generationContext);
        }

        public <T> T accept(BytecodeNode parent, BytecodeVisitor<T> visitor) {
            return (T)visitor.visitIf(parent, (IfStatement)this.body);
        }

        public BytecodeNode produceBlockAndPosition() {
            BytecodeBlock blockAndPosition = new BytecodeBlock();
            blockAndPosition.append((BytecodeNode)this.block);
            blockAndPosition.append((BytecodeNode)this.position);
            return blockAndPosition;
        }

        public BytecodeExpression blockAndPositionIsNull() {
            return this.block.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{this.position});
        }
    }
}

