/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestosql.sql.planner.ExpressionExtractor;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Lookup;
import io.prestosql.sql.planner.optimizations.PlanNodeSearcher;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.WindowNode;
import io.prestosql.sql.tree.DefaultExpressionTraversalVisitor;
import io.prestosql.sql.tree.DefaultTraversalVisitor;
import io.prestosql.sql.tree.DereferenceExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.LambdaExpression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.SubqueryExpression;
import io.prestosql.sql.tree.SymbolReference;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class SymbolsExtractor {
    private SymbolsExtractor() {
    }

    public static Set<Symbol> extractUnique(PlanNode node) {
        ImmutableSet.Builder uniqueSymbols = ImmutableSet.builder();
        ExpressionExtractor.extractExpressions(node).forEach(expression -> uniqueSymbols.addAll(SymbolsExtractor.extractUnique(expression)));
        return uniqueSymbols.build();
    }

    public static Set<Symbol> extractUniqueNonRecursive(PlanNode node) {
        ImmutableSet.Builder uniqueSymbols = ImmutableSet.builder();
        ExpressionExtractor.extractExpressionsNonRecursive(node).forEach(expression -> uniqueSymbols.addAll(SymbolsExtractor.extractUnique(expression)));
        return uniqueSymbols.build();
    }

    public static Set<Symbol> extractUnique(PlanNode node, Lookup lookup) {
        ImmutableSet.Builder uniqueSymbols = ImmutableSet.builder();
        ExpressionExtractor.extractExpressions(node, lookup).forEach(expression -> uniqueSymbols.addAll(SymbolsExtractor.extractUnique(expression)));
        return uniqueSymbols.build();
    }

    public static Set<Symbol> extractUnique(Expression expression) {
        return ImmutableSet.copyOf(SymbolsExtractor.extractAll(expression));
    }

    public static Set<Symbol> extractUnique(Iterable<? extends Expression> expressions) {
        ImmutableSet.Builder unique = ImmutableSet.builder();
        for (Expression expression : expressions) {
            unique.addAll(SymbolsExtractor.extractAll(expression));
        }
        return unique.build();
    }

    public static Set<Symbol> extractUnique(AggregationNode.Aggregation aggregation) {
        return ImmutableSet.copyOf(SymbolsExtractor.extractAll(aggregation));
    }

    public static Set<Symbol> extractUnique(WindowNode.Function function) {
        return ImmutableSet.copyOf(SymbolsExtractor.extractAll(function));
    }

    public static List<Symbol> extractAll(Expression expression) {
        ImmutableList.Builder builder = ImmutableList.builder();
        new SymbolBuilderVisitor().process((Node)expression, builder);
        return builder.build();
    }

    public static List<Symbol> extractAll(AggregationNode.Aggregation aggregation) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Expression argument : aggregation.getArguments()) {
            builder.addAll(SymbolsExtractor.extractAll(argument));
        }
        aggregation.getFilter().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        aggregation.getOrderingScheme().ifPresent(orderBy -> builder.addAll(orderBy.getOrderBy()));
        aggregation.getMask().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public static List<Symbol> extractAll(WindowNode.Function function) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Expression argument : function.getArguments()) {
            builder.addAll(SymbolsExtractor.extractAll(argument));
        }
        function.getFrame().getEndValue().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        function.getFrame().getSortKeyCoercedForFrameEndComparison().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        function.getFrame().getStartValue().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        function.getFrame().getSortKeyCoercedForFrameStartComparison().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public static Set<QualifiedName> extractNames(Expression expression, Set<NodeRef<Expression>> columnReferences) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        new QualifiedNameBuilderVisitor(columnReferences, true).process((Node)expression, builder);
        return builder.build();
    }

    public static Set<QualifiedName> extractNamesNoSubqueries(Expression expression, Set<NodeRef<Expression>> columnReferences) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        new QualifiedNameBuilderVisitor(columnReferences, false).process((Node)expression, builder);
        return builder.build();
    }

    public static Set<Symbol> extractOutputSymbols(PlanNode planNode) {
        return SymbolsExtractor.extractOutputSymbols(planNode, Lookup.noLookup());
    }

    public static Set<Symbol> extractOutputSymbols(PlanNode planNode, Lookup lookup) {
        return (Set)PlanNodeSearcher.searchFrom(planNode, lookup).findAll().stream().flatMap(node -> node.getOutputSymbols().stream()).collect(ImmutableSet.toImmutableSet());
    }

    private static class QualifiedNameBuilderVisitor
    extends DefaultTraversalVisitor<ImmutableSet.Builder<QualifiedName>> {
        private final Set<NodeRef<Expression>> columnReferences;
        private final boolean recurseIntoSubqueries;

        private QualifiedNameBuilderVisitor(Set<NodeRef<Expression>> columnReferences, boolean recurseIntoSubqueries) {
            this.columnReferences = Objects.requireNonNull(columnReferences, "columnReferences is null");
            this.recurseIntoSubqueries = recurseIntoSubqueries;
        }

        protected Void visitDereferenceExpression(DereferenceExpression node, ImmutableSet.Builder<QualifiedName> builder) {
            if (this.columnReferences.contains(NodeRef.of((Node)node))) {
                builder.add((Object)DereferenceExpression.getQualifiedName((DereferenceExpression)node));
            } else {
                this.process((Node)node.getBase(), builder);
            }
            return null;
        }

        protected Void visitIdentifier(Identifier node, ImmutableSet.Builder<QualifiedName> builder) {
            builder.add((Object)QualifiedName.of((String)node.getValue()));
            return null;
        }

        protected Void visitSubqueryExpression(SubqueryExpression node, ImmutableSet.Builder<QualifiedName> context) {
            if (!this.recurseIntoSubqueries) {
                return null;
            }
            return super.visitSubqueryExpression(node, context);
        }
    }

    private static class SymbolBuilderVisitor
    extends DefaultExpressionTraversalVisitor<ImmutableList.Builder<Symbol>> {
        private SymbolBuilderVisitor() {
        }

        protected Void visitSymbolReference(SymbolReference node, ImmutableList.Builder<Symbol> builder) {
            builder.add((Object)Symbol.from((Expression)node));
            return null;
        }

        protected Void visitLambdaExpression(LambdaExpression node, ImmutableList.Builder<Symbol> context) {
            return null;
        }
    }
}

