/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.cost.CachingCostProvider;
import io.prestosql.cost.CachingStatsProvider;
import io.prestosql.cost.CostCalculator;
import io.prestosql.cost.CostProvider;
import io.prestosql.cost.StatsCalculator;
import io.prestosql.cost.StatsProvider;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.matching.Capture;
import io.prestosql.matching.Match;
import io.prestosql.matching.Pattern;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.sql.planner.PlanNodeIdAllocator;
import io.prestosql.sql.planner.RuleStatsRecorder;
import io.prestosql.sql.planner.SymbolAllocator;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.iterative.GroupReference;
import io.prestosql.sql.planner.iterative.Lookup;
import io.prestosql.sql.planner.iterative.Memo;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.RuleIndex;
import io.prestosql.sql.planner.optimizations.PlanOptimizer;
import io.prestosql.sql.planner.plan.PlanNode;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class IterativeOptimizer
implements PlanOptimizer {
    private final RuleStatsRecorder stats;
    private final StatsCalculator statsCalculator;
    private final CostCalculator costCalculator;
    private final List<PlanOptimizer> legacyRules;
    private final RuleIndex ruleIndex;
    private final Predicate<Session> useLegacyRules;

    public IterativeOptimizer(RuleStatsRecorder stats, StatsCalculator statsCalculator, CostCalculator costCalculator, Set<Rule<?>> rules) {
        this(stats, statsCalculator, costCalculator, session -> false, (List<PlanOptimizer>)ImmutableList.of(), rules);
    }

    public IterativeOptimizer(RuleStatsRecorder stats, StatsCalculator statsCalculator, CostCalculator costCalculator, Predicate<Session> useLegacyRules, List<PlanOptimizer> legacyRules, Set<Rule<?>> newRules) {
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
        this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
        this.useLegacyRules = Objects.requireNonNull(useLegacyRules, "useLegacyRules is null");
        this.legacyRules = ImmutableList.copyOf(legacyRules);
        this.ruleIndex = RuleIndex.builder().register(newRules).build();
        stats.registerAll(newRules);
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        if (this.useLegacyRules.test(session) && !this.legacyRules.isEmpty()) {
            for (PlanOptimizer optimizer : this.legacyRules) {
                plan = optimizer.optimize(plan, session, symbolAllocator.getTypes(), symbolAllocator, idAllocator, warningCollector);
            }
            return plan;
        }
        Memo memo = new Memo(idAllocator, plan);
        Lookup lookup = Lookup.from(planNode -> Stream.of(memo.resolve((GroupReference)planNode)));
        Duration timeout = SystemSessionProperties.getOptimizerTimeout(session);
        Context context = new Context(memo, lookup, idAllocator, symbolAllocator, System.nanoTime(), timeout.toMillis(), session, warningCollector);
        this.exploreGroup(memo.getRootGroup(), context);
        return memo.extract();
    }

    private boolean exploreGroup(int group, Context context) {
        boolean progress = this.exploreNode(group, context);
        while (this.exploreChildren(group, context)) {
            progress = true;
            if (this.exploreNode(group, context)) continue;
            break;
        }
        return progress;
    }

    private boolean exploreNode(int group, Context context) {
        PlanNode node = context.memo.getNode(group);
        boolean done = false;
        boolean progress = false;
        while (!done) {
            context.checkTimeoutNotExhausted();
            done = true;
            Iterator possiblyMatchingRules = this.ruleIndex.getCandidates(node).iterator();
            while (possiblyMatchingRules.hasNext()) {
                Rule.Result result;
                Rule rule = (Rule)possiblyMatchingRules.next();
                if (!rule.isEnabled(context.session) || !(result = this.transform(node, rule, context)).getTransformedPlan().isPresent()) continue;
                node = context.memo.replace(group, result.getTransformedPlan().get(), rule.getClass().getName());
                done = false;
                progress = true;
            }
        }
        return progress;
    }

    private <T> Rule.Result transform(PlanNode node, Rule<T> rule, Context context) {
        Capture nodeCapture = Capture.newCapture();
        Pattern pattern = rule.getPattern().capturedAs(nodeCapture);
        Iterator matches = pattern.match((Object)node, (Object)context.lookup).iterator();
        while (matches.hasNext()) {
            long duration;
            Rule.Result result;
            Match match = (Match)matches.next();
            try {
                long start = System.nanoTime();
                result = rule.apply(match.capture(nodeCapture), match.captures(), this.ruleContext(context));
                duration = System.nanoTime() - start;
            }
            catch (RuntimeException e) {
                this.stats.recordFailure(rule);
                throw e;
            }
            this.stats.record(rule, duration, !result.isEmpty());
            if (!result.getTransformedPlan().isPresent()) continue;
            return result;
        }
        return Rule.Result.empty();
    }

    private boolean exploreChildren(int group, Context context) {
        boolean progress = false;
        PlanNode expression = context.memo.getNode(group);
        for (PlanNode child : expression.getSources()) {
            Preconditions.checkState((boolean)(child instanceof GroupReference), (Object)("Expected child to be a group reference. Found: " + child.getClass().getName()));
            if (!this.exploreGroup(((GroupReference)child).getGroupId(), context)) continue;
            progress = true;
        }
        return progress;
    }

    private Rule.Context ruleContext(final Context context) {
        final CachingStatsProvider statsProvider = new CachingStatsProvider(this.statsCalculator, Optional.of(context.memo), context.lookup, context.session, context.symbolAllocator.getTypes());
        final CachingCostProvider costProvider = new CachingCostProvider(this.costCalculator, statsProvider, Optional.of(context.memo), context.session, context.symbolAllocator.getTypes());
        return new Rule.Context(){

            @Override
            public Lookup getLookup() {
                return context.lookup;
            }

            @Override
            public PlanNodeIdAllocator getIdAllocator() {
                return context.idAllocator;
            }

            @Override
            public SymbolAllocator getSymbolAllocator() {
                return context.symbolAllocator;
            }

            @Override
            public Session getSession() {
                return context.session;
            }

            @Override
            public StatsProvider getStatsProvider() {
                return statsProvider;
            }

            @Override
            public CostProvider getCostProvider() {
                return costProvider;
            }

            @Override
            public void checkTimeoutNotExhausted() {
                context.checkTimeoutNotExhausted();
            }

            @Override
            public WarningCollector getWarningCollector() {
                return context.warningCollector;
            }
        };
    }

    private static class Context {
        private final Memo memo;
        private final Lookup lookup;
        private final PlanNodeIdAllocator idAllocator;
        private final SymbolAllocator symbolAllocator;
        private final long startTimeInNanos;
        private final long timeoutInMilliseconds;
        private final Session session;
        private final WarningCollector warningCollector;

        public Context(Memo memo, Lookup lookup, PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator, long startTimeInNanos, long timeoutInMilliseconds, Session session, WarningCollector warningCollector) {
            Preconditions.checkArgument((timeoutInMilliseconds >= 0L ? 1 : 0) != 0, (Object)"Timeout has to be a non-negative number [milliseconds]");
            this.memo = memo;
            this.lookup = lookup;
            this.idAllocator = idAllocator;
            this.symbolAllocator = symbolAllocator;
            this.startTimeInNanos = startTimeInNanos;
            this.timeoutInMilliseconds = timeoutInMilliseconds;
            this.session = session;
            this.warningCollector = warningCollector;
        }

        public void checkTimeoutNotExhausted() {
            if (TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.startTimeInNanos) >= this.timeoutInMilliseconds) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.OPTIMIZER_TIMEOUT, String.format("The optimizer exhausted the time limit of %d ms", this.timeoutInMilliseconds));
            }
        }
    }
}

