/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableMap;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.PlanNode;
import java.util.Map;
import java.util.Optional;

class AggregationDecorrelation {
    private AggregationDecorrelation() {
    }

    public static boolean isDistinctOperator(PlanNode node) {
        return node instanceof AggregationNode && ((AggregationNode)node).getAggregations().isEmpty() && ((AggregationNode)node).getGroupingSetCount() == 1 && ((AggregationNode)node).hasNonEmptyGroupingSet();
    }

    public static Map<Symbol, AggregationNode.Aggregation> rewriteWithMasks(Map<Symbol, AggregationNode.Aggregation> aggregations, Map<Symbol, Symbol> masks) {
        ImmutableMap.Builder rewritten = ImmutableMap.builder();
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : aggregations.entrySet()) {
            Symbol symbol = entry.getKey();
            AggregationNode.Aggregation aggregation = entry.getValue();
            rewritten.put((Object)symbol, (Object)new AggregationNode.Aggregation(aggregation.getResolvedFunction(), aggregation.getArguments(), aggregation.isDistinct(), aggregation.getFilter(), aggregation.getOrderingScheme(), Optional.of(masks.get(symbol))));
        }
        return rewritten.build();
    }
}

