/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolsExtractor;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.ApplyNode;
import io.prestosql.sql.planner.plan.Patterns;
import java.util.List;
import java.util.Set;

public class PruneApplyCorrelation
implements Rule<ApplyNode> {
    private static final Pattern<ApplyNode> PATTERN = Patterns.applyNode();

    @Override
    public Pattern<ApplyNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ApplyNode applyNode, Captures captures, Rule.Context context) {
        Set<Symbol> subquerySymbols = SymbolsExtractor.extractUnique(applyNode.getSubquery(), context.getLookup());
        List newCorrelation = (List)applyNode.getCorrelation().stream().filter(subquerySymbols::contains).collect(ImmutableList.toImmutableList());
        if (newCorrelation.size() < applyNode.getCorrelation().size()) {
            return Rule.Result.ofPlanNode(new ApplyNode(applyNode.getId(), applyNode.getInput(), applyNode.getSubquery(), applyNode.getSubqueryAssignments(), newCorrelation, applyNode.getOriginSubquery()));
        }
        return Rule.Result.empty();
    }
}

