/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.SymbolsExtractor;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.Util;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.SpatialJoinNode;
import java.util.Set;

public class PruneSpatialJoinChildrenColumns
implements Rule<SpatialJoinNode> {
    private static final Pattern<SpatialJoinNode> PATTERN = Patterns.spatialJoin();

    @Override
    public Pattern<SpatialJoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(SpatialJoinNode spatialJoinNode, Captures captures, Rule.Context context) {
        ImmutableSet requiredOutputAndFilterSymbols = ImmutableSet.builder().addAll(spatialJoinNode.getOutputSymbols()).addAll(SymbolsExtractor.extractUnique(spatialJoinNode.getFilter())).build();
        ImmutableSet.Builder leftInputs = ImmutableSet.builder().addAll((Iterable)requiredOutputAndFilterSymbols);
        spatialJoinNode.getLeftPartitionSymbol().ifPresent(arg_0 -> ((ImmutableSet.Builder)leftInputs).add(arg_0));
        ImmutableSet.Builder rightInputs = ImmutableSet.builder().addAll((Iterable)requiredOutputAndFilterSymbols);
        spatialJoinNode.getRightPartitionSymbol().ifPresent(arg_0 -> ((ImmutableSet.Builder)rightInputs).add(arg_0));
        return Util.restrictChildOutputs(context.getIdAllocator(), spatialJoinNode, new Set[]{leftInputs.build(), rightInputs.build()}).map(Rule.Result::ofPlanNode).orElse(Rule.Result.empty());
    }
}

