/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.PlanVisitor;
import io.prestosql.util.MoreLists;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;

@Immutable
public class GroupIdNode
extends PlanNode {
    private final PlanNode source;
    private final List<List<Symbol>> groupingSets;
    private final Map<Symbol, Symbol> groupingColumns;
    private final List<Symbol> aggregationArguments;
    private final Symbol groupIdSymbol;

    @JsonCreator
    public GroupIdNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="groupingSets") List<List<Symbol>> groupingSets, @JsonProperty(value="groupingColumns") Map<Symbol, Symbol> groupingColumns, @JsonProperty(value="aggregationArguments") List<Symbol> aggregationArguments, @JsonProperty(value="groupIdSymbol") Symbol groupIdSymbol) {
        super(id);
        this.source = Objects.requireNonNull(source);
        this.groupingSets = MoreLists.listOfListsCopy(Objects.requireNonNull(groupingSets, "groupingSets is null"));
        this.groupingColumns = ImmutableMap.copyOf(Objects.requireNonNull(groupingColumns));
        this.aggregationArguments = ImmutableList.copyOf(aggregationArguments);
        this.groupIdSymbol = Objects.requireNonNull(groupIdSymbol);
        ImmutableSet outputs = ImmutableSet.copyOf(source.getOutputSymbols());
        Preconditions.checkArgument((boolean)outputs.containsAll(groupingColumns.values()));
        Preconditions.checkArgument((boolean)outputs.containsAll(aggregationArguments));
        Preconditions.checkArgument((boolean)Sets.intersection(groupingColumns.keySet(), (Set)ImmutableSet.copyOf(aggregationArguments)).isEmpty(), (Object)"aggregation columns and grouping set columns must be a disjoint set");
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.builder().addAll((Iterable)this.groupingSets.stream().flatMap(Collection::stream).collect(Collectors.toSet())).addAll(this.aggregationArguments).add((Object)this.groupIdSymbol).build();
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public List<List<Symbol>> getGroupingSets() {
        return this.groupingSets;
    }

    @JsonProperty
    public Map<Symbol, Symbol> getGroupingColumns() {
        return this.groupingColumns;
    }

    @JsonProperty
    public List<Symbol> getAggregationArguments() {
        return this.aggregationArguments;
    }

    @JsonProperty
    public Symbol getGroupIdSymbol() {
        return this.groupIdSymbol;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitGroupId(this, context);
    }

    public Set<Symbol> getInputSymbols() {
        return ImmutableSet.builder().addAll(this.aggregationArguments).addAll((Iterable)this.groupingSets.stream().map(set -> set.stream().map(this.groupingColumns::get).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toSet())).build();
    }

    public Set<Symbol> getCommonGroupingColumns() {
        HashSet intersection = new HashSet(this.groupingSets.get(0));
        for (int i = 1; i < this.groupingSets.size(); ++i) {
            intersection.retainAll((Collection)this.groupingSets.get(i));
        }
        return ImmutableSet.copyOf(intersection);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new GroupIdNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.groupingSets, this.groupingColumns, this.aggregationArguments, this.groupIdSymbol);
    }
}

