/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.metadata.TableHandle;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.PlanVisitor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TableScanNode
extends PlanNode {
    private final TableHandle table;
    private final List<Symbol> outputSymbols;
    private final Map<Symbol, ColumnHandle> assignments;
    private final TupleDomain<ColumnHandle> enforcedConstraint;
    private final boolean forDelete;

    public static TableScanNode newInstance(PlanNodeId id, TableHandle table, List<Symbol> outputs, Map<Symbol, ColumnHandle> assignments, boolean forDelete) {
        return new TableScanNode(id, table, outputs, assignments, (TupleDomain<ColumnHandle>)TupleDomain.all(), forDelete);
    }

    @JsonCreator
    public TableScanNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="table") TableHandle table, @JsonProperty(value="outputSymbols") List<Symbol> outputs, @JsonProperty(value="assignments") Map<Symbol, ColumnHandle> assignments, @JsonProperty(value="forDelete") boolean forDelete) {
        super(id);
        this.table = Objects.requireNonNull(table, "table is null");
        this.outputSymbols = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputs, "outputs is null"));
        this.assignments = ImmutableMap.copyOf(Objects.requireNonNull(assignments, "assignments is null"));
        Preconditions.checkArgument((boolean)assignments.keySet().containsAll(outputs), (Object)"assignments does not cover all of outputs");
        this.enforcedConstraint = null;
        this.forDelete = forDelete;
    }

    public TableScanNode(PlanNodeId id, TableHandle table, List<Symbol> outputs, Map<Symbol, ColumnHandle> assignments, TupleDomain<ColumnHandle> enforcedConstraint, boolean forDelete) {
        super(id);
        this.table = Objects.requireNonNull(table, "table is null");
        this.outputSymbols = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputs, "outputs is null"));
        this.assignments = ImmutableMap.copyOf(Objects.requireNonNull(assignments, "assignments is null"));
        Preconditions.checkArgument((boolean)assignments.keySet().containsAll(outputs), (Object)"assignments does not cover all of outputs");
        this.enforcedConstraint = Objects.requireNonNull(enforcedConstraint, "enforcedConstraint is null");
        this.forDelete = forDelete;
    }

    @JsonProperty(value="table")
    public TableHandle getTable() {
        return this.table;
    }

    @Override
    @JsonProperty(value="outputSymbols")
    public List<Symbol> getOutputSymbols() {
        return this.outputSymbols;
    }

    @JsonProperty(value="assignments")
    public Map<Symbol, ColumnHandle> getAssignments() {
        return this.assignments;
    }

    public TupleDomain<ColumnHandle> getEnforcedConstraint() {
        Preconditions.checkState((this.enforcedConstraint != null ? 1 : 0) != 0, (Object)"enforcedConstraint should only be used in planner. It is not transported to workers.");
        return this.enforcedConstraint;
    }

    @JsonProperty(value="forDelete")
    public boolean isForDelete() {
        return this.forDelete;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableScan(this, context);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("outputSymbols", this.outputSymbols).add("assignments", this.assignments).add("enforcedConstraint", this.enforcedConstraint).add("forDelete", this.forDelete).toString();
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((boolean)newChildren.isEmpty(), (Object)"newChildren is not empty");
        return this;
    }
}

