/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;

public final class BigintOperators {
    private BigintOperators() {
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="bigint")
    public static long add(@SqlType(value="bigint") long left, @SqlType(value="bigint") long right) {
        try {
            return Math.addExact(left, right);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("bigint addition overflow: %s + %s", left, right), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="bigint")
    public static long subtract(@SqlType(value="bigint") long left, @SqlType(value="bigint") long right) {
        try {
            return Math.subtractExact(left, right);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("bigint subtraction overflow: %s - %s", left, right), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="bigint")
    public static long multiply(@SqlType(value="bigint") long left, @SqlType(value="bigint") long right) {
        try {
            return Math.multiplyExact(left, right);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("bigint multiplication overflow: %s * %s", left, right), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.DIVIDE)
    @SqlType(value="bigint")
    public static long divide(@SqlType(value="bigint") long left, @SqlType(value="bigint") long right) {
        try {
            if (left == Long.MIN_VALUE && right == -1L) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("bigint division overflow: %s / %s", left, right));
            }
            return left / right;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero", (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.MODULUS)
    @SqlType(value="bigint")
    public static long modulus(@SqlType(value="bigint") long left, @SqlType(value="bigint") long right) {
        try {
            return left % right;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero", (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.NEGATION)
    @SqlType(value="bigint")
    public static long negate(@SqlType(value="bigint") long value) {
        try {
            return Math.negateExact(value);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "bigint negation overflow: " + value, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="boolean")
    public static boolean castToBoolean(@SqlType(value="bigint") long value) {
        return value != 0L;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="integer")
    public static long castToInteger(@SqlType(value="bigint") long value) {
        try {
            return Math.toIntExact(value);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Out of range for integer: " + value, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.SATURATED_FLOOR_CAST)
    @SqlType(value="integer")
    public static long saturatedFloorCastToInteger(@SqlType(value="bigint") long value) {
        return Ints.saturatedCast((long)value);
    }

    @ScalarOperator(value=OperatorType.SATURATED_FLOOR_CAST)
    @SqlType(value="smallint")
    public static long saturatedFloorCastToSmallint(@SqlType(value="bigint") long value) {
        return Shorts.saturatedCast((long)value);
    }

    @ScalarOperator(value=OperatorType.SATURATED_FLOOR_CAST)
    @SqlType(value="tinyint")
    public static long saturatedFloorCastToTinyint(@SqlType(value="bigint") long value) {
        return SignedBytes.saturatedCast((long)value);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="smallint")
    public static long castToSmallint(@SqlType(value="bigint") long value) {
        try {
            return Shorts.checkedCast((long)value);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Out of range for smallint: " + value, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="tinyint")
    public static long castToTinyint(@SqlType(value="bigint") long value) {
        try {
            return SignedBytes.checkedCast((long)value);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Out of range for tinyint: " + value, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="double")
    public static double castToDouble(@SqlType(value="bigint") long value) {
        return value;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="real")
    public static long castToReal(@SqlType(value="bigint") long value) {
        return Float.floatToRawIntBits(value);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice castToVarchar(@SqlType(value="bigint") long value) {
        return Slices.utf8Slice((String)String.valueOf(value));
    }
}

