/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTimeField;
import org.joda.time.chrono.ISOChronology;

public final class DateTimeOperators {
    private static final DateTimeField MILLIS_OF_DAY = ISOChronology.getInstanceUTC().millisOfDay();
    private static final DateTimeField MONTH_OF_YEAR_UTC = ISOChronology.getInstanceUTC().monthOfYear();

    private DateTimeOperators() {
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="date")
    public static long datePlusIntervalDayToSecond(@SqlType(value="date") long date, @SqlType(value="interval day to second") long interval) {
        if (MILLIS_OF_DAY.get(interval) != 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Cannot add hour, minutes or seconds to a date");
        }
        return date + TimeUnit.MILLISECONDS.toDays(interval);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="date")
    public static long intervalDayToSecondPlusDate(@SqlType(value="interval day to second") long interval, @SqlType(value="date") long date) {
        return DateTimeOperators.datePlusIntervalDayToSecond(date, interval);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="date")
    public static long datePlusIntervalYearToMonth(@SqlType(value="date") long date, @SqlType(value="interval year to month") long interval) {
        long millis = MONTH_OF_YEAR_UTC.add(TimeUnit.DAYS.toMillis(date), interval);
        return TimeUnit.MILLISECONDS.toDays(millis);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="date")
    public static long intervalYearToMonthPlusDate(@SqlType(value="interval year to month") long interval, @SqlType(value="date") long date) {
        return DateTimeOperators.datePlusIntervalYearToMonth(date, interval);
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="date")
    public static long dateMinusIntervalDayToSecond(@SqlType(value="date") long date, @SqlType(value="interval day to second") long interval) {
        if (MILLIS_OF_DAY.get(interval) != 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Cannot subtract hour, minutes or seconds from a date");
        }
        return date - TimeUnit.MILLISECONDS.toDays(interval);
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="date")
    public static long dateMinusIntervalYearToMonth(@SqlType(value="date") long date, @SqlType(value="interval year to month") long interval) {
        return DateTimeOperators.datePlusIntervalYearToMonth(date, -interval);
    }
}

