/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;

public final class IntegerOperators {
    private IntegerOperators() {
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="integer")
    public static long add(@SqlType(value="integer") long left, @SqlType(value="integer") long right) {
        try {
            return Math.addExact((int)left, (int)right);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("integer addition overflow: %s + %s", left, right), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="integer")
    public static long subtract(@SqlType(value="integer") long left, @SqlType(value="integer") long right) {
        try {
            return Math.subtractExact((int)left, (int)right);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("integer subtraction overflow: %s - %s", left, right), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="integer")
    public static long multiply(@SqlType(value="integer") long left, @SqlType(value="integer") long right) {
        try {
            return Math.multiplyExact((int)left, (int)right);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("integer multiplication overflow: %s * %s", left, right), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.DIVIDE)
    @SqlType(value="integer")
    public static long divide(@SqlType(value="integer") long left, @SqlType(value="integer") long right) {
        try {
            return left / right;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero", (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.MODULUS)
    @SqlType(value="integer")
    public static long modulus(@SqlType(value="integer") long left, @SqlType(value="integer") long right) {
        try {
            return left % right;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero", (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.NEGATION)
    @SqlType(value="integer")
    public static long negate(@SqlType(value="integer") long value) {
        try {
            return Math.negateExact((int)value);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "integer negation overflow: " + value, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="bigint")
    public static long castToBigint(@SqlType(value="integer") long value) {
        return value;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="smallint")
    public static long castToSmallint(@SqlType(value="integer") long value) {
        try {
            return Shorts.checkedCast((long)value);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Out of range for smallint: " + value, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="tinyint")
    public static long castToTinyint(@SqlType(value="integer") long value) {
        try {
            return SignedBytes.checkedCast((long)value);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Out of range for tinyint: " + value, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="boolean")
    public static boolean castToBoolean(@SqlType(value="integer") long value) {
        return value != 0L;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="double")
    public static double castToDouble(@SqlType(value="integer") long value) {
        return value;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="real")
    public static long castToReal(@SqlType(value="integer") long value) {
        return Float.floatToRawIntBits(value);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice castToVarchar(@SqlType(value="integer") long value) {
        return Slices.utf8Slice((String)String.valueOf(value));
    }

    @ScalarOperator(value=OperatorType.SATURATED_FLOOR_CAST)
    @SqlType(value="smallint")
    public static long saturatedFloorCastToSmallint(@SqlType(value="integer") long value) {
        return Shorts.saturatedCast((long)value);
    }

    @ScalarOperator(value=OperatorType.SATURATED_FLOOR_CAST)
    @SqlType(value="tinyint")
    public static long saturatedFloorCastToTinyint(@SqlType(value="integer") long value) {
        return SignedBytes.saturatedCast((long)value);
    }
}

