/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.util;

import io.prestosql.array.LongBigArray;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.LongBinaryOperator;
import org.openjdk.jol.info.ClassLayout;

public class LongLong2LongOpenCustomBigHashMap
implements Hash {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LongLong2LongOpenCustomBigHashMap.class).instanceSize();
    private static final boolean ASSERTS = false;
    protected LongBigArray key;
    protected LongBigArray value;
    protected long mask;
    protected boolean containsNullKey;
    protected final HashStrategy strategy;
    protected long n;
    protected long maxFill;
    protected final long minN;
    protected long size;
    protected final float f;
    protected long defRetValue;

    public LongLong2LongOpenCustomBigHashMap(long expected, float f, HashStrategy strategy) {
        this.strategy = strategy;
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0L) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.minN = this.n = HashCommon.bigArraySize((long)expected, (float)f);
        this.mask = this.n - 1L;
        this.maxFill = HashCommon.maxFill((long)this.n, (float)f);
        this.key = new LongBigArray();
        this.key.ensureCapacity((this.n + 1L) * 2L);
        this.value = new LongBigArray();
        this.value.ensureCapacity(this.n + 1L);
    }

    public LongLong2LongOpenCustomBigHashMap(long expected, HashStrategy strategy) {
        this(expected, 0.75f, strategy);
    }

    public LongLong2LongOpenCustomBigHashMap(HashStrategy strategy) {
        this(1024L, 0.75f, strategy);
    }

    public void defaultReturnValue(long rv) {
        this.defRetValue = rv;
    }

    public long defaultReturnValue() {
        return this.defRetValue;
    }

    public long sizeOf() {
        return (long)INSTANCE_SIZE + this.key.sizeOf() + this.value.sizeOf();
    }

    public HashStrategy strategy() {
        return this.strategy;
    }

    private long realSize() {
        return this.containsNullKey ? this.size - 1L : this.size;
    }

    private long removeEntry(long pos) {
        long oldValue = this.value.get(pos);
        --this.size;
        this.shiftKeys(pos);
        if (this.n > this.minN && this.size < this.maxFill / 4L && this.n > 1024L) {
            this.rehash(this.n / 2L);
        }
        return oldValue;
    }

    private long removeNullEntry() {
        this.containsNullKey = false;
        long oldValue = this.value.get(this.n);
        --this.size;
        if (this.n > this.minN && this.size < this.maxFill / 4L && this.n > 1024L) {
            this.rehash(this.n / 2L);
        }
        return oldValue;
    }

    private long find(long k1, long k2) {
        if (this.strategy.equals(k1, k2, 0L, 0L)) {
            return this.containsNullKey ? this.n : -(this.n + 1L);
        }
        LongBigArray key = this.key;
        long pos = HashCommon.mix((long)this.strategy.hashCode(k1, k2)) & this.mask;
        long curr1 = key.get(pos * 2L);
        long curr2 = key.get(pos * 2L + 1L);
        if (curr1 == 0L && curr2 == 0L) {
            return -(pos + 1L);
        }
        if (this.strategy.equals(k1, k2, curr1, curr2)) {
            return pos;
        }
        do {
            pos = pos + 1L & this.mask;
            curr1 = key.get(pos * 2L);
            curr2 = key.get(pos * 2L + 1L);
            if (curr1 != 0L || curr2 != 0L) continue;
            return -(pos + 1L);
        } while (!this.strategy.equals(k1, k2, curr1, curr2));
        return pos;
    }

    private void insert(long pos, long k1, long k2, long v) {
        if (pos == this.n) {
            this.containsNullKey = true;
        }
        this.key.set(pos * 2L, k1);
        this.key.set(pos * 2L + 1L, k2);
        this.value.set(pos, v);
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.bigArraySize((long)(this.size + 1L), (float)this.f));
        }
    }

    public long put(long k1, long k2, long v) {
        long pos = this.find(k1, k2);
        if (pos < 0L) {
            this.insert(-pos - 1L, k1, k2, v);
            return this.defRetValue;
        }
        long oldValue = this.value.get(pos);
        this.value.set(pos, v);
        return oldValue;
    }

    private long addToValue(long pos, long incr) {
        long oldValue = this.value.get(pos);
        this.value.set(pos, oldValue + incr);
        return oldValue;
    }

    public long addTo(long k1, long k2, long incr) {
        long pos;
        if (this.strategy.equals(k1, k2, 0L, 0L)) {
            if (this.containsNullKey) {
                return this.addToValue(this.n, incr);
            }
            pos = this.n;
            this.containsNullKey = true;
        } else {
            LongBigArray key = this.key;
            pos = HashCommon.mix((long)this.strategy.hashCode(k1, k2)) & this.mask;
            long curr1 = key.get(pos * 2L);
            long curr2 = key.get(pos * 2L + 1L);
            if (curr1 != 0L || curr2 != 0L) {
                if (this.strategy.equals(curr1, curr2, k1, k2)) {
                    return this.addToValue(pos, incr);
                }
                pos = pos + 1L & this.mask;
                curr1 = key.get(pos * 2L);
                curr2 = key.get(pos * 2L + 1L);
                while (curr1 != 0L || curr2 != 0L) {
                    if (this.strategy.equals(curr1, curr2, k1, k2)) {
                        return this.addToValue(pos, incr);
                    }
                    pos = pos + 1L & this.mask;
                    curr1 = key.get(pos * 2L);
                    curr2 = key.get(pos * 2L + 1L);
                }
            }
        }
        this.key.set(pos * 2L, k1);
        this.key.set(pos * 2L + 1L, k2);
        this.value.set(pos, this.defRetValue + incr);
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.bigArraySize((long)(this.size + 1L), (float)this.f));
        }
        return this.defRetValue;
    }

    protected final void shiftKeys(long pos) {
        LongBigArray key = this.key;
        while (true) {
            long curr2;
            long curr1;
            long last = pos;
            pos = pos + 1L & this.mask;
            while (true) {
                curr1 = key.get(pos * 2L);
                curr2 = key.get(pos * 2L + 1L);
                if (curr1 == 0L && curr2 == 0L) {
                    key.set(last * 2L, 0L);
                    key.set(last * 2L + 1L, 0L);
                    return;
                }
                long slot = HashCommon.mix((long)this.strategy.hashCode(curr1, curr2)) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1L & this.mask;
            }
            key.set(last * 2L, curr1);
            key.set(last * 2L + 1L, curr2);
            this.value.set(last, this.value.get(pos));
        }
    }

    public long remove(long k1, long k2) {
        if (this.strategy.equals(k1, k2, 0L, 0L)) {
            if (this.containsNullKey) {
                return this.removeNullEntry();
            }
            return this.defRetValue;
        }
        LongBigArray key = this.key;
        long pos = HashCommon.mix((long)this.strategy.hashCode(k1, k2)) & this.mask;
        long curr1 = key.get(pos * 2L);
        long curr2 = key.get(pos * 2L + 1L);
        if (curr1 == 0L && curr2 == 0L) {
            return this.defRetValue;
        }
        if (this.strategy.equals(k1, k2, curr1, curr2)) {
            return this.removeEntry(pos);
        }
        do {
            pos = pos + 1L & this.mask;
            curr1 = key.get(pos * 2L);
            curr2 = key.get(pos * 2L + 1L);
            if (curr1 != 0L || curr2 != 0L) continue;
            return this.defRetValue;
        } while (!this.strategy.equals(k1, k2, curr1, curr2));
        return this.removeEntry(pos);
    }

    public long get(long k1, long k2) {
        if (this.strategy.equals(k1, k2, 0L, 0L)) {
            return this.containsNullKey ? this.value.get(this.n) : this.defRetValue;
        }
        LongBigArray key = this.key;
        long pos = HashCommon.mix((long)this.strategy.hashCode(k1, k2)) & this.mask;
        long curr1 = key.get(pos * 2L);
        long curr2 = key.get(pos * 2L + 1L);
        if (curr1 == 0L && curr2 == 0L) {
            return this.defRetValue;
        }
        if (this.strategy.equals(k1, k2, curr1, curr2)) {
            return this.value.get(pos);
        }
        do {
            pos = pos + 1L & this.mask;
            curr1 = key.get(pos * 2L);
            curr2 = key.get(pos * 2L + 1L);
            if (curr1 != 0L || curr2 != 0L) continue;
            return this.defRetValue;
        } while (!this.strategy.equals(k1, k2, curr1, curr2));
        return this.value.get(pos);
    }

    public boolean containsKey(long k1, long k2) {
        if (this.strategy.equals(k1, k2, 0L, 0L)) {
            return this.containsNullKey;
        }
        LongBigArray key = this.key;
        long pos = HashCommon.mix((long)this.strategy.hashCode(k1, k2)) & this.mask;
        long curr1 = key.get(pos * 2L);
        long curr2 = key.get(pos * 2L + 1L);
        if (curr1 == 0L && curr2 == 0L) {
            return false;
        }
        if (this.strategy.equals(k1, k2, curr1, curr2)) {
            return true;
        }
        do {
            pos = pos + 1L & this.mask;
            curr1 = key.get(pos * 2L);
            curr2 = key.get(pos * 2L + 1L);
            if (curr1 != 0L || curr2 != 0L) continue;
            return false;
        } while (!this.strategy.equals(k1, k2, curr1, curr2));
        return true;
    }

    public boolean containsValue(long v) {
        LongBigArray value = this.value;
        LongBigArray key = this.key;
        if (this.containsNullKey && value.get(this.n) == v) {
            return true;
        }
        long i = this.n;
        while (i-- != 0L) {
            if (key.get(i * 2L) == 0L && key.get(i * 2L + 1L) == 0L || value.get(i) != v) continue;
            return true;
        }
        return false;
    }

    public long getOrDefault(long k1, long k2, long defaultValue) {
        if (this.strategy.equals(k1, k2, 0L, 0L)) {
            return this.containsNullKey ? this.value.get(this.n) : defaultValue;
        }
        LongBigArray key = this.key;
        long pos = HashCommon.mix((long)this.strategy.hashCode(k1, k2)) & this.mask;
        long curr1 = key.get(pos * 2L);
        long curr2 = key.get(pos * 2L + 1L);
        if (curr1 == 0L && curr2 == 0L) {
            return defaultValue;
        }
        if (this.strategy.equals(k1, k2, curr1, curr2)) {
            return this.value.get(pos);
        }
        do {
            pos = pos + 1L & this.mask;
            curr1 = key.get(pos * 2L);
            curr2 = key.get(pos * 2L + 1L);
            if (curr1 != 0L || curr2 != 0L) continue;
            return defaultValue;
        } while (!this.strategy.equals(k1, k2, curr1, curr2));
        return this.value.get(pos);
    }

    public long putIfAbsent(long k1, long k2, long v) {
        long pos = this.find(k1, k2);
        if (pos >= 0L) {
            return this.value.get(pos);
        }
        this.insert(-pos - 1L, k1, k2, v);
        return this.defRetValue;
    }

    public boolean remove(long k1, long k2, long v) {
        if (this.strategy.equals(k1, k2, 0L, 0L)) {
            if (this.containsNullKey && v == this.value.get(this.n)) {
                this.removeNullEntry();
                return true;
            }
            return false;
        }
        LongBigArray key = this.key;
        long pos = HashCommon.mix((long)this.strategy.hashCode(k1, k2)) & this.mask;
        long curr1 = key.get(pos * 2L);
        long curr2 = key.get(pos * 2L + 1L);
        if (curr1 == 0L && curr2 == 0L) {
            return false;
        }
        if (this.strategy.equals(k1, k2, curr1, curr2) && v == this.value.get(pos)) {
            this.removeEntry(pos);
            return true;
        }
        do {
            pos = pos + 1L & this.mask;
            curr1 = key.get(pos * 2L);
            curr2 = key.get(pos * 2L + 1L);
            if (curr1 != 0L || curr2 != 0L) continue;
            return false;
        } while (!this.strategy.equals(k1, k2, curr1, curr2) || v != this.value.get(pos));
        this.removeEntry(pos);
        return true;
    }

    public boolean replace(long k1, long k2, long oldValue, long v) {
        long pos = this.find(k1, k2);
        if (pos < 0L || oldValue != this.value.get(pos)) {
            return false;
        }
        this.value.set(pos, v);
        return true;
    }

    public long replace(long k1, long k2, long v) {
        long pos = this.find(k1, k2);
        if (pos < 0L) {
            return this.defRetValue;
        }
        long oldValue = this.value.get(pos);
        this.value.set(pos, v);
        return oldValue;
    }

    public long computeIfAbsent(long k1, long k2, LongBinaryOperator mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        long pos = this.find(k1, k2);
        if (pos >= 0L) {
            return this.value.get(pos);
        }
        long newValue = mappingFunction.applyAsLong(k1, k2);
        this.insert(-pos - 1L, k1, k2, newValue);
        return newValue;
    }

    public long merge(long k1, long k2, long v, BiFunction<? super Long, ? super Long, ? extends Long> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        long pos = this.find(k1, k2);
        if (pos < 0L) {
            this.insert(-pos - 1L, k1, k2, v);
            return v;
        }
        Long newValue = remappingFunction.apply((Long)this.value.get(pos), (Long)v);
        if (newValue == null) {
            if (this.strategy.equals(k1, k2, 0L, 0L)) {
                this.removeNullEntry();
            } else {
                this.removeEntry(pos);
            }
            return this.defRetValue;
        }
        this.value.set(pos, newValue.longValue());
        return newValue;
    }

    public void clear() {
        if (this.size == 0L) {
            return;
        }
        this.size = 0L;
        this.containsNullKey = false;
        this.key.fill(0L);
    }

    public long size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0L;
    }

    public boolean trim() {
        return this.trim(this.size);
    }

    public boolean trim(long n) {
        long l = HashCommon.bigArraySize((long)n, (float)this.f);
        if (l >= this.n || this.size > HashCommon.maxFill((long)l, (float)this.f)) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(long newN) {
        LongBigArray key = this.key;
        LongBigArray value = this.value;
        long mask = newN - 1L;
        LongBigArray newKey = new LongBigArray();
        newKey.ensureCapacity((newN + 1L) * 2L);
        LongBigArray newValue = new LongBigArray();
        newValue.ensureCapacity(newN + 1L);
        long i = this.n;
        long j = this.realSize();
        while (j-- != 0L) {
            --i;
            while (key.get(i * 2L) == 0L && key.get(i * 2L + 1L) == 0L) {
                --i;
            }
            long pos = HashCommon.mix((long)this.strategy.hashCode(key.get(i * 2L), key.get(i * 2L + 1L))) & mask;
            if (newKey.get(pos * 2L) != 0L || newKey.get(pos * 2L + 1L) != 0L) {
                pos = pos + 1L & mask;
                while (newKey.get(pos * 2L) != 0L || newKey.get(pos * 2L + 1L) != 0L) {
                    pos = pos + 1L & mask;
                }
            }
            newKey.set(pos * 2L, key.get(i * 2L));
            newKey.set(pos * 2L + 1L, key.get(i * 2L + 1L));
            newValue.set(pos, value.get(i));
        }
        newValue.set(newN, value.get(this.n));
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.maxFill((long)this.n, (float)this.f);
        this.key = newKey;
        this.value = newValue;
    }

    private void checkTable() {
    }

    public static interface HashStrategy {
        public long hashCode(long var1, long var3);

        public boolean equals(long var1, long var3, long var5, long var7);
    }
}

