/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.Preconditions;
import java.util.Objects;

public final class NodeLocation {
    private final int line;
    private final int column;

    public NodeLocation(int line, int column) {
        Preconditions.checkArgument((line >= 1 ? 1 : 0) != 0, (String)"line must be at least one, got: %s", (int)line);
        Preconditions.checkArgument((column >= 1 ? 1 : 0) != 0, (String)"column must be at least one, got: %s", (int)column);
        this.line = line;
        this.column = column;
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.column;
    }

    public String toString() {
        return this.line + ":" + this.column;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeLocation that = (NodeLocation)o;
        return this.line == that.line && this.column == that.column;
    }

    public int hashCode() {
        return Objects.hash(this.line, this.column);
    }
}

